@extends('layouts.app')

@section('content')
<section class="section">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h4 class="card-title">Edit Level</h4>
            <a href="{{ route('levels.index') }}" class="btn btn-secondary btn-sm">Back</a>
        </div>
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <strong>There were some problems with your input:</strong>
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            <form action="{{ route('levels.update', $level->id) }}" method="POST">
                @csrf
                <div class="form-group">
                    <label for="name">Level Name</label>
                    <input type="text" name="name" class="form-control" required value="{{ old('name', $level->name) }}">
                </div>
                <div class="form-group">
                    <label for="description">Description (Optional)</label>
                    <textarea name="description" class="form-control" rows="3">{{ old('description', $level->description) }}</textarea>
                </div>
                <button type="submit" class="btn btn-success">Update Level</button>
            </form>
        </div>
    </div>
</section>
@endsection
