@extends('layouts.app')

@section('content')
<div class="container py-4">
    <div class="d-flex align-items-center justify-content-between mb-2">
        <h3 class="mb-0">Registration — Age Category</h3>
        <a href="{{ route('club.registration.index') }}" class="btn btn-outline-secondary">
            ← Back
        </a>
    </div>
    <div class="text-muted mb-3">
        <strong>
            {{ $ageCategory->name
                ?? ( (isset($ageCategory->min_yob) || isset($ageCategory->max_yob))
                        ? (($ageCategory->min_yob ?? '—') . '–' . ($ageCategory->max_yob ?? '—'))
                        : (($ageCategory->min_age ?? '—') . '–' . ($ageCategory->max_age ?? '—') . ' years')
                   )
            }}
        </strong>
    </div>

    {{-- Flash / Errors --}}
    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $e)
                    <li>{{ $e }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    {{-- SEARCH (standalone GET form) --}}
    <form method="get" class="mb-3">
        <div class="input-group">
            <input type="text" name="search" value="{{ $search }}" class="form-control" placeholder="Search athlete…">
            <button class="btn btn-outline-primary" type="submit">Search</button>
        </div>
    </form>

    {{-- MAIN POST FORM --}}
    <form method="post" action="{{ route('club.registration.store', [$ageCategory->id]) }}" id="registration-form">
        @csrf

        <div class="card mb-3 shadow-sm">
            <div class="card-header">
                <strong>Choose Competition</strong>
            </div>
            <div class="card-body row g-2 align-items-end">
                <div class="col-md-6">
                    <label class="form-label">Competition</label>
                    <select name="competition_id" id="competition_id" class="form-control" required>
                        <option value="" disabled {{ old('competition_id') ? '' : 'selected' }}>Choose competition…</option>
                        @foreach($competitions as $c)
                            @if ($c['is_open'])
                                <option
                                    value="{{ $c['id'] }}"
                                    data-open="1"
                                    {{ (string)old('competition_id') === (string)$c['id'] ? 'selected' : '' }}
                                >
                                    {{ $c['name'] }} — Open ({{ $c['window'] }})
                                </option>
                            @endif
                        @endforeach
                    </select>
                </div>
                <div class="col-md-6">
                    <span id="comp-status" class="badge bg-secondary">Select a competition</span>
                </div>
            </div>
        </div>

        {{-- ATHLETES TABLE --}}
        <div class="card shadow-sm">
            <div class="card-header d-flex align-items-center justify-content-between">
                <div>
                    <strong>Athletes ({{ $eligibleAthletes->count() }})</strong>
                </div>
                <div>
                    <button type="button" class="btn btn-sm btn-outline-secondary" id="btn-select-all">Select All</button>
                    <button type="button" class="btn btn-sm btn-outline-secondary ms-2" id="btn-clear-all">Clear All</button>
                </div>
            </div>

            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table table-hover align-middle mb-0">
                        <thead class="table-light">
                        <tr>
                            <th style="width:56px;">#</th>
                            <th>Name</th>
                            <th>DOB</th>
                            <th>Active Competition(s)</th> {{-- optional badges --}}
                            <th style="width:80px;">Select</th>
                        </tr>
                        </thead>
                        <tbody>
                        @forelse($eligibleAthletes as $idx => $a)
                            @php
                                // Optional: these are provided if your controller passes them.
                                $ids = isset($regsByAthlete) ? ($regsByAthlete[$a->id] ?? []) : [];
                                $names = [];
                                if (!empty($ids) && isset($openCompNames)) {
                                    foreach ($ids as $cid) { $names[] = $openCompNames[$cid] ?? $cid; }
                                }
                                $dataIn = implode(',', $ids);
                            @endphp
                            <tr>
                                <td>{{ $idx + 1 }}</td>
                                <td>{{ $a->first_name }} {{ $a->last_name }}</td>
                                <td>{{ $a->dob ?? $a->date_of_birth }}</td>
                                <td>
                                    @if(!empty($names))
                                        @foreach($names as $nm)
                                            <span class="badge bg-info text-dark me-1">{{ $nm }}</span>
                                        @endforeach
                                    @else
                                        <span class="text-muted">—</span>
                                    @endif
                                </td>
                                <td>
                                    <input
                                        type="checkbox"
                                        class="chk-athlete"
                                        name="athlete_ids[]"
                                        value="{{ $a->id }}"
                                        data-in="{{ $dataIn }}" {{-- ids of open competitions athlete is already in --}}
                                    >
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center text-muted py-4">No eligible athletes found.</td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>

            <div class="card-footer d-flex justify-content-between">
                <button type="submit" id="btn-save" class="btn btn-primary">Save Selections</button>

                <a class="btn btn-outline-success"
                   id="btn-export"
                   href="#"
                   onclick="
                        const cid = document.getElementById('competition_id').value;
                        if (cid) {
                            this.href='{{ route('club.registration.export', [$ageCategory->id]) }}?competition_id='+cid;
                        } else { return false; }
                   ">
                    Export Excel
                </a>
            </div>
        </div>
    </form>
</div>
@endsection

@section('js')
<script>
document.addEventListener('DOMContentLoaded', () => {
    const comp = document.getElementById('competition_id');
    const btnSave = document.getElementById('btn-save');
    const status = document.getElementById('comp-status');
    const boxes = document.querySelectorAll('input.chk-athlete');
    const btnSelectAll = document.getElementById('btn-select-all');
    const btnClearAll  = document.getElementById('btn-clear-all');

    function syncChecks(selectedCompId) {
        document.querySelectorAll('input.chk-athlete').forEach(chk => {
            const tr = chk.closest('tr');
            const list = (chk.getAttribute('data-in') || '').split(',').filter(Boolean);
            const isInSelected = selectedCompId ? list.includes(String(selectedCompId)) : false;

            // pre-check and highlight if already in this (open) competition
            chk.checked = isInSelected;
            if (isInSelected) tr.classList.add('table-success');
            else tr.classList.remove('table-success');
        });
    }

    function refreshCompetitionState() {
        const opt = comp.options[comp.selectedIndex];
        if (!opt || !opt.value) {
            btnSave.disabled = true;
            status.textContent = 'Select a competition';
            status.className = 'badge bg-secondary';
            syncChecks(null);
            return;
        }
        const open = Number(opt.getAttribute('data-open')) === 1;
        btnSave.disabled = !open;
        status.textContent = open ? 'Registration Open' : 'Registration Closed';
        status.className = 'badge ' + (open ? 'bg-success' : 'bg-danger');

        syncChecks(opt.value);
    }

    // auto-pick first valid option if none chosen
    if (!comp.value) {
        for (let i = 0; i < comp.options.length; i++) {
            if (comp.options[i].value) { comp.selectedIndex = i; break; }
        }
    }

    if (btnSelectAll) btnSelectAll.addEventListener('click', () => boxes.forEach(b => b.checked = true));
    if (btnClearAll)  btnClearAll.addEventListener('click', () => boxes.forEach(b => b.checked = false));

    comp.addEventListener('change', refreshCompetitionState);
    refreshCompetitionState();
});
</script>
@endsection
