@extends('layouts.app')

@section('content')
<div class="container py-4">
    <h3 class="mb-4">Club Registration — Choose Age Category</h3>

    @if (session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if (session('error'))
        <div class="alert alert-danger">{{ session('error') }}</div>
    @endif
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $e)
                    <li>{{ $e }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <div class="row g-3">
        @forelse($ageCategories as $ac)
            <div class="col-md-4">
                <div class="card h-100 shadow-sm">
                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title mb-2">
                            {{ $ac->name
                                ?? ( (isset($ac->min_age) || isset($ac->max_age))
                                        ? (($ac->min_age ?? '—') . '–' . ($ac->max_age ?? '—'))
                                        : (($ac->min_age ?? '—') . '–' . ($ac->max_age ?? '—') . ' years')
                                   )
                            }}
                        </h5>
                        @if(!is_null($ac->min_age ?? null) || !is_null($ac->max_age ?? null))
                            <div class="text-muted mb-2">
                                Age window: {{ $ac->min_age ?? '—' }}–{{ $ac->max_age ?? '—' }}
                            </div>
                        @endif
                        <a href="{{ route('club.registration.athletes', [$ac->id]) }}"
                           class="btn btn-primary mt-auto">
                            Open
                        </a>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-12">
                <div class="alert alert-info mb-0">No age categories configured.</div>
            </div>
        @endforelse
    </div>
</div>
@endsection
