<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\CertificateController;
use App\Http\Controllers\ClubController;
use App\Http\Controllers\CompetitionController;
Auth::routes();
Route::middleware(['auth'])->group(function () {
    Route::get('/index', [App\Http\Controllers\HomeController::class, 'index'])->name('home');
    // Age Categories
    Route::get('age_categories', [App\Http\Controllers\AgeCategoryController::class, 'index'])->name('age_categories.index');
    Route::get('age_categories/create', [App\Http\Controllers\AgeCategoryController::class, 'create'])->name('age_categories.create');
    Route::post('age_categories/store', [App\Http\Controllers\AgeCategoryController::class, 'store'])->name('age_categories.store');
    Route::get('age_categories/edit/{id}', [App\Http\Controllers\AgeCategoryController::class, 'edit'])->name('age_categories.edit');
    Route::post('age_categories/update/{id}', [App\Http\Controllers\AgeCategoryController::class, 'update'])->name('age_categories.update');
    Route::get('age_categories/delete/{id}', [App\Http\Controllers\AgeCategoryController::class, 'destroy'])->name('age_categories.destroy');

    // Apparatus
    Route::get('apparatus', [App\Http\Controllers\ApparatusController::class, 'index'])->name('apparatus.index');
    Route::get('apparatus/create', [App\Http\Controllers\ApparatusController::class, 'create'])->name('apparatus.create');
    Route::post('apparatus/store', [App\Http\Controllers\ApparatusController::class, 'store'])->name('apparatus.store');
    Route::get('apparatus/edit/{id}', [App\Http\Controllers\ApparatusController::class, 'edit'])->name('apparatus.edit');
    Route::post('apparatus/update/{id}', [App\Http\Controllers\ApparatusController::class, 'update'])->name('apparatus.update');
    Route::get('apparatus/delete/{id}', [App\Http\Controllers\ApparatusController::class, 'destroy'])->name('apparatus.destroy');

    // Athletes
    Route::get('athletes', [App\Http\Controllers\AthleteController::class, 'index'])->name('athletes.index');
    Route::get('athletes/create', [App\Http\Controllers\AthleteController::class, 'create'])->name('athletes.create');
    Route::post('athletes/store', [App\Http\Controllers\AthleteController::class, 'store'])->name('athletes.store');
    Route::get('athletes/edit/{id}', [App\Http\Controllers\AthleteController::class, 'edit'])->name('athletes.edit');
    Route::put('athletes/update/{id}', [App\Http\Controllers\AthleteController::class, 'update'])->name('athletes.update');
    Route::get('athletes/delete/{id}', [App\Http\Controllers\AthleteController::class, 'destroy'])->name('athletes.destroy');
    Route::post('/athletes/import', [App\Http\Controllers\AthleteController::class, 'import'])->name('athletes.import');

    // Categories
    Route::get('categories', [App\Http\Controllers\CategoryController::class, 'index'])->name('categories.index');
    Route::get('categories/create', [App\Http\Controllers\CategoryController::class, 'create'])->name('categories.create');
    Route::post('categories/store', [App\Http\Controllers\CategoryController::class, 'store'])->name('categories.store');
    Route::get('categories/edit/{id}', [App\Http\Controllers\CategoryController::class, 'edit'])->name('categories.edit');
    Route::post('categories/update/{id}', [App\Http\Controllers\CategoryController::class, 'update'])->name('categories.update');
    Route::get('categories/delete/{id}', [App\Http\Controllers\CategoryController::class, 'destroy'])->name('categories.destroy');

    // Clubs
    Route::get('clubs', [App\Http\Controllers\ClubController::class, 'index'])->name('clubs.index');
    Route::get('clubs/create', [App\Http\Controllers\ClubController::class, 'create'])->name('clubs.create');
    Route::post('clubs/store', [App\Http\Controllers\ClubController::class, 'store'])->name('clubs.store');
    Route::get('clubs/edit/{id}', [App\Http\Controllers\ClubController::class, 'edit'])->name('clubs.edit');
    Route::put('clubs/update/{id}', [App\Http\Controllers\ClubController::class, 'update'])->name('clubs.update');
    Route::get('clubs/delete/{id}', [App\Http\Controllers\ClubController::class, 'destroy'])->name('clubs.destroy');

    // Competitions
    Route::get('competitions', [App\Http\Controllers\CompetitionController::class, 'index'])->name('competitions.index');
    Route::get('competitions/create', [App\Http\Controllers\CompetitionController::class, 'create'])->name('competitions.create');
    Route::post('competitions/store', [App\Http\Controllers\CompetitionController::class, 'store'])->name('competitions.store');
    Route::get('competitions/edit/{id}', [App\Http\Controllers\CompetitionController::class, 'edit'])->name('competitions.edit');
    Route::post('competitions/update/{id}', [App\Http\Controllers\CompetitionController::class, 'update'])->name('competitions.update');
    Route::get('competitions/delete/{id}', [App\Http\Controllers\CompetitionController::class, 'destroy'])->name('competitions.destroy');
    Route::get('competitions/show/{id}', [App\Http\Controllers\CompetitionController::class, 'showReport'])->name('competitions.show');

    // Judges
    Route::get('judges', [App\Http\Controllers\JudgeController::class, 'index'])->name('judges.index');
    Route::get('judges/create', [App\Http\Controllers\JudgeController::class, 'create'])->name('judges.create');
    Route::post('judges/store', [App\Http\Controllers\JudgeController::class, 'store'])->name('judges.store');
    Route::get('judges/edit/{id}', [App\Http\Controllers\JudgeController::class, 'edit'])->name('judges.edit');
    Route::post('judges/update/{id}', [App\Http\Controllers\JudgeController::class, 'update'])->name('judges.update');
    Route::get('judges/delete/{id}', [App\Http\Controllers\JudgeController::class, 'destroy'])->name('judges.destroy');

    // Scores
    Route::get('scores', [App\Http\Controllers\ScoreController::class, 'index'])->name('scores.index');
    Route::get('scores/create', [App\Http\Controllers\ScoreController::class, 'create'])->name('scores.create');
    Route::post('scores/store', [App\Http\Controllers\ScoreController::class, 'store'])->name('scores.store');
    Route::get('scores/edit/{id}', [App\Http\Controllers\ScoreController::class, 'edit'])->name('scores.edit');
    Route::post('scores/update/{id}', [App\Http\Controllers\ScoreController::class, 'update'])->name('scores.update');
    Route::get('scores/delete/{id}', [App\Http\Controllers\ScoreController::class, 'destroy'])->name('scores.destroy');
    Route::post('/scores/{score}/update-field', [\App\Http\Controllers\ScoreController::class, 'updateField'])->name('scores.updateField');

    // Countries
    Route::get('countries', [App\Http\Controllers\CountryController::class, 'index'])->name('countries.index');
    Route::get('countries/create', [App\Http\Controllers\CountryController::class, 'create'])->name('countries.create');
    Route::post('countries/store', [App\Http\Controllers\CountryController::class, 'store'])->name('countries.store');
    Route::get('countries/edit/{id}', [App\Http\Controllers\CountryController::class, 'edit'])->name('countries.edit');
    Route::post('countries/update/{id}', [App\Http\Controllers\CountryController::class, 'update'])->name('countries.update');
    Route::get('countries/delete/{id}', [App\Http\Controllers\CountryController::class, 'destroy'])->name('countries.destroy');

    // levels
    Route::get('levels', [App\Http\Controllers\LevelController::class, 'index'])->name('levels.index');
    Route::get('levels/create', [App\Http\Controllers\LevelController::class, 'create'])->name('levels.create');
    Route::post('levels/store', [App\Http\Controllers\LevelController::class, 'store'])->name('levels.store');
    Route::get('levels/edit/{id}', [App\Http\Controllers\LevelController::class, 'edit'])->name('levels.edit');
    Route::post('levels/update/{id}', [App\Http\Controllers\LevelController::class, 'update'])->name('levels.update');
    Route::get('levels/delete/{id}', [App\Http\Controllers\LevelController::class, 'destroy'])->name('levels.destroy');

    // Groups
    Route::get('groups', [App\Http\Controllers\GroupController::class, 'index'])->name('groups.index');
    Route::get('groups/create', [App\Http\Controllers\GroupController::class, 'create'])->name('groups.create');
    Route::post('groups/store', [App\Http\Controllers\GroupController::class, 'store'])->name('groups.store');
    Route::get('groups/edit/{id}', [App\Http\Controllers\GroupController::class, 'edit'])->name('groups.edit');
    Route::post('groups/update/{id}', [App\Http\Controllers\GroupController::class, 'update'])->name('groups.update');
    Route::get('groups/delete/{id}', [App\Http\Controllers\GroupController::class, 'destroy'])->name('groups.destroy');
    Route::post('/groups/import-excel', [App\Http\Controllers\GroupController::class, 'importExcel'])->name('groups.import.excel');

    // Assign Apparatus
    Route::get('assignapparatus', [App\Http\Controllers\AssignApparatusController::class, 'index'])->name('assignapparatus.index');
    Route::get('assignapparatus/create', [App\Http\Controllers\AssignApparatusController::class, 'create'])->name('assignapparatus.create');
    Route::post('assignapparatus/store', [App\Http\Controllers\AssignApparatusController::class, 'store'])->name('assignapparatus.store');
    Route::get('assignapparatus/edit/{id}', [App\Http\Controllers\AssignApparatusController::class, 'edit'])->name('assignapparatus.edit');
    Route::post('assignapparatus/update/{id}', [App\Http\Controllers\AssignApparatusController::class, 'update'])->name('assignapparatus.update');
    Route::delete('assignapparatus/delete/{id}', [App\Http\Controllers\AssignApparatusController::class, 'destroy'])->name('assignapparatus.destroy');
    Route::post('assignapparatus/import', [App\Http\Controllers\AssignApparatusController::class, 'import'])->name('assignapparatus.import');

    // Competition Athlete
    Route::get('competitionathlete', [App\Http\Controllers\CompetitionAthleteController::class, 'index'])->name('competitionathlete.index');
    Route::get('competitionathlete/create', [App\Http\Controllers\CompetitionAthleteController::class, 'create'])->name('competitionathlete.create');
    Route::post('competitionathlete/store', [App\Http\Controllers\CompetitionAthleteController::class, 'store'])->name('competitionathlete.store');
    Route::get('competitionathlete/edit/{id}', [App\Http\Controllers\CompetitionAthleteController::class, 'edit'])->name('competitionathlete.edit');
    Route::post('competitionathlete/update/{id}', [App\Http\Controllers\CompetitionAthleteController::class, 'update'])->name('competitionathlete.update');
    Route::delete('competitionathlete/delete/{id}', [App\Http\Controllers\CompetitionAthleteController::class, 'destroy'])->name('competitionathlete.destroy');
    Route::get('competitions/{id}/generate-rotations', [App\Http\Controllers\CompetitionController::class, 'generateRotations'])->name('competitions.generateRotations');
    Route::get('/get-competition-groups/{competition}', [App\Http\Controllers\CompetitionAthleteController::class, 'getGroups'])->name('competition.groups');
    Route::get('/get-competition-athletes/{competition}', [App\Http\Controllers\CompetitionAthleteController::class, 'getAthletes'])->name('competition.athletes');
    Route::post('/competition-athlete/import-excel', [App\Http\Controllers\CompetitionAthleteController::class, 'importExcel'])->name('competitionathlete.import.excel');

    // Competition Athlete
    Route::get('judge/competitions', [App\Http\Controllers\JudgeCompetitionController::class, 'index'])->name('judge.competitions');
    Route::post('judge/set-competition', [App\Http\Controllers\JudgeCompetitionController::class, 'setCompetition'])->name('judge.setCompetition');
    Route::get('judge/round', [App\Http\Controllers\JudgeCompetitionController::class, 'showRound'])->name('judge.round');
    Route::post('judge/submitRound', [App\Http\Controllers\JudgeCompetitionController::class, 'submitRound'])->name('judge.submitRound');
    Route::post('/judge/round/{round}/complete', [App\Http\Controllers\JudgeCompetitionController::class, 'completeRound'])->name('main_judge.completeRound');
    Route::get('/judge/check-active-round', [App\Http\Controllers\JudgeCompetitionController::class, 'checkActiveRound'])->name('judge.checkActiveRound');
    Route::post('/scores/{score}/update-bonus', [App\Http\Controllers\JudgeCompetitionController::class, 'updateBonusAjax'])->name('scores.updateBonusAjax');
    Route::get('/judge/round/athletes', [App\Http\Controllers\JudgeCompetitionController::class, 'athleteList'])->name('judge.round.athletes');
    Route::get('/judge/round/athletes/{athleteId}/score', [App\Http\Controllers\JudgeCompetitionController::class, 'athleteForm'])->name('judge.round.athletes.form');
    Route::post('/judge/round/athletes/{athleteId}/score', [App\Http\Controllers\JudgeCompetitionController::class, 'submitAthleteScore'])->name('judge.round.athletes.submit');

    // Profile
    Route::get('/profile/edit', [App\Http\Controllers\ProfileController::class, 'edit'])->name('profile.edit');
    Route::post('/profile/update', [App\Http\Controllers\ProfileController::class, 'update'])->name('profile.update');
    Route::get('/profile/password', [App\Http\Controllers\ProfileController::class, 'changePasswordForm'])->name('profile.password');
    Route::post('/profile/password', [App\Http\Controllers\ProfileController::class, 'changePassword'])->name('profile.password.update');

    Route::prefix('judge')->group(function () {
        Route::get('/vault2', [\App\Http\Controllers\Vault2Controller::class, 'index'])->name('judge.vault2.index');
        Route::get('/vault2/{competition}', [\App\Http\Controllers\Vault2Controller::class, 'show'])->name('judge.vault2.show');
        Route::post('/vault2/{competition}/athletes/{athlete}', [\App\Http\Controllers\Vault2Controller::class, 'store'])->name('judge.vault2.store');
        Route::get('/vault2/{competition}/export/{fmt}', [\App\Http\Controllers\Vault2Controller::class, 'export'])->name('judge.vault2.export');
    });

    // Owner Club Links
    Route::get('/owner/club/index', [App\Http\Controllers\Club\HomeController::class, 'index'])->name('owner.club.index');
    Route::prefix('club')
        ->name('club.')
        ->middleware(['auth'])
        ->group(function () {
            // Screen 1: choose Age Category (no competition yet)
            Route::get('registration', [App\Http\Controllers\Club\CompetitionAthleteController::class, 'index'])->name('registration.index');

            // Screen 2: list athletes filtered by Age Category; user selects Competition on this page
            Route::get('registration/age/{ageCategory}', [App\Http\Controllers\Club\CompetitionAthleteController::class, 'athletes'])->name('registration.athletes');

            // Persist selections into the chosen Competition
            Route::post('registration/age/{ageCategory}', [App\Http\Controllers\Club\CompetitionAthleteController::class, 'store'])->name('registration.store');

            // Optional export (needs competition_id as query param)
            Route::get('registration/age/{ageCategory}/export', [App\Http\Controllers\Club\CompetitionAthleteController::class, 'export'])->name('registration.export');
        });

    Route::prefix('competitions/{competition}')->group(function () {
        Route::get('certificates', [CertificateController::class, 'index'])->name('certificates.index');
        Route::post('certificates/template', [CertificateController::class, 'storeTemplate'])->name('certificates.template.store');
        Route::get('certificates/preview', [CertificateController::class, 'preview'])->name('certificates.preview');

        Route::post('certificates/export-selected', [CertificateController::class, 'exportSelected'])->name('certificates.exportSelected');
        Route::post('certificates/export-all', [CertificateController::class, 'exportAll'])->name('certificates.exportAll');
    });

    Route::get('/clubs/{club}/athletes', [ClubController::class, 'getAthletes'])
     ->name('clubs.athletes');

Route::get('/competitions/team/create', [CompetitionController::class, 'createTeam'])
     ->name('competitions.team.create');

Route::post('/competitions/team/store', [CompetitionController::class, 'storeTeam'])
     ->name('competitions.team.store');
});

// routes/web.php
Route::get('/', [App\Http\Controllers\PublicLeaderboardController::class, 'index'])->name('public.leaderboard.index');
Route::get('/leaderboard/{competition}', [App\Http\Controllers\PublicLeaderboardController::class, 'show'])->name('public.leaderboard.show');
Route::get('/leaderboard/{competitionId}/refresh', [App\Http\Controllers\PublicLeaderboardController::class, 'refresh'])->name('public.leaderboard.refresh');
Route::prefix('leaderboard')
    ->name('public.leaderboard.')
    ->group(function () {
        Route::get('/', [\App\Http\Controllers\PublicLeaderboardController::class, 'index'])->name('index'); // public

        Route::get('/{competitionId}', [\App\Http\Controllers\PublicLeaderboardController::class, 'show'])->name('show'); // public

        // NEW: live display (apparatusId can be numeric OR 'all')
        Route::get('/{competitionId}/live/{apparatusId}', [\App\Http\Controllers\PublicLeaderboardController::class, 'liveScreen'])->name('live'); // public

        // NEW: JSON feed used by the live page
        Route::get('/{competitionId}/live/{apparatusId}/feed', [\App\Http\Controllers\PublicLeaderboardController::class, 'liveFeed'])->name('live.feed'); // public
    });
