

<?php $__env->startSection('content'); ?>
 <div class="card">
        <div class="card-header">
            <h4 class="card-title">Create Team Competition</h4>
        </div>
        <div class="card-body">
        <?php if($errors->any()): ?>
            <div class="alert alert-danger"><?php echo e(implode(', ', $errors->all())); ?></div>
        <?php endif; ?>

        <form method="POST" action="<?php echo e(route('competitions.team.store')); ?>" id="teamCompetitionForm">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="is_team_competition" value="1">

            <div class="form-group">
                <label>Competition Title</label>
                <input type="text" name="title" class="form-control" required>
            </div>

            <div class="form-row">
                <div class="form-group col-md-6">
                    <label>Start Date</label>
                    <input type="date" name="start_date" class="form-control" required>
                </div>
                <div class="form-group col-md-6">
                    <label>End Date</label>
                    <input type="date" name="end_date" class="form-control" required>
                </div>
            </div>
            <div class="form-group">
                <label for="location">Location</label>
                <input type="text" name="location" class="form-control" value="<?php echo e(old('location')); ?>">
            </div>
            <div class="form-group">
                <label for="scoring_type">Scoring Type</label>
                <select name="scoring_type" class="form-control" required>
                    <option value="FIG" <?php echo e(old('scoring_type') == 'FIG' ? 'selected' : ''); ?>>FIG</option>
                    <option value="American" <?php echo e(old('scoring_type') == 'American' ? 'selected' : ''); ?>>American</option>
                </select>
            </div>
            <div class="form-row">
                <div class="col-md-6">
                    <label>Club A</label>
                    <select name="club_a_id" id="clubA" class="form-control" required>
                        <option value="">Select Club A</option>
                        <?php $__currentLoopData = $clubs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $club): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($club->id); ?>"><?php echo e($club->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <div id="clubAPlayers" class="mt-3"></div>
                </div>

                <div class="col-md-6">
                    <label>Club B</label>
                    <select name="club_b_id" id="clubB" class="form-control" required>
                        <option value="">Select Club B</option>
                        <?php $__currentLoopData = $clubs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $club): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($club->id); ?>"><?php echo e($club->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <div id="clubBPlayers" class="mt-3"></div>
                </div>
            </div>

            <div class="alert alert-warning mt-3 d-none" id="equalCheck">
                Select equal number of athletes in both clubs to enable tournament creation.
            </div>

            <button class="btn btn-primary mt-3" type="submit" id="createBtn" disabled>
                Create Tournament
            </button>
        </form>
    </div>
   </div>
 </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {

            // Load club athletes dynamically (simulate AJAX or real /clubs/{id}/athletes endpoint)
            function loadAthletes(clubId, targetDiv, clubLabel) {
                if (!clubId) return $(targetDiv).empty();

                // Real AJAX version (keep if your route returns JSON):
                $.get(`/clubs/${clubId}/athletes`, function(data) {
                    renderAthleteList(targetDiv, data, clubLabel);
                });
            }

            // Render the checkbox list and counter
            function renderAthleteList(targetDiv, athletes, clubLabel) {
                const nameAttr = clubLabel === 'A' ? 'club_a_athletes[]' : 'club_b_athletes[]';
                let html = `
                            <div class="border p-2 rounded">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <strong>Club ${clubLabel} Athletes</strong>
                                <span class="badge badge-primary" id="${clubLabel.toLowerCase()}Count">0 selected</span>
                            </div>
                        `;
                athletes.forEach(a => {
                    html += `
                            <div class="form-check">
                                <input class="form-check-input athlete-box"
                                    type="checkbox"
                                    name="${nameAttr}"
                                    data-club="${clubLabel.toLowerCase()}"
                                    value="${a.id}">
                                <label class="form-check-label">${a.first_name} ${a.last_name}</label>
                            </div>`;
                });

                html += `</div>`;
                $(targetDiv).html(html);
                bindEqualCheck();
            }


            // Event: when clubs change
            $('#clubA').on('change', function() {
                loadAthletes($(this).val(), '#clubAPlayers', 'A');
            });
            $('#clubB').on('change', function() {
                loadAthletes($(this).val(), '#clubBPlayers', 'B');
            });

            // Compare both teams’ selections and update counters
            function bindEqualCheck() {
                $('.athlete-box').off('change').on('change', function() {
                    const aCount = $('.athlete-box[data-club="a"]:checked').length;
                    const bCount = $('.athlete-box[data-club="b"]:checked').length;
                    $('#aCount, #bCount').removeClass('text-danger text-success');

                    $('#aCount').text(`${aCount} selected`);
                    $('#bCount').text(`${bCount} selected`);

                    if (aCount === bCount && aCount > 0) {
                        $('#createBtn').prop('disabled', false);
                        $('#equalCheck').addClass('d-none');
                    } else {
                        $('#createBtn').prop('disabled', true);
                        $('#equalCheck').removeClass('d-none');
                    }

                    // color hint: green if matched
                    const color = (aCount === bCount && aCount > 0) ? 'text-success' : 'text-danger';
                    $('#aCount').addClass(color);
                    $('#bCount').addClass(color);
                });
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/competitions/team_create.blade.php ENDPATH**/ ?>