<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/buttons.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h4 class="card-title">Competition Athlete Assignments</h4>

            <div class="btn-group">
                <a href="<?php echo e(route('competitionathlete.create')); ?>" class="btn btn-primary">
                    Assign Athlete
                </a>

                <button class="btn btn-success" data-toggle="collapse" data-target="#importForm">
                    Import Athletes
                </button>
            </div>
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <div id="importForm" class="collapse mt-2">
                    <div class="card card-body">
                        <a href="<?php echo e(asset('competition_athlete_import_template.xlsx')); ?>"
                            class="btn btn-sm btn-info mb-5 w-25">Download Sample File</a>
                        <form action="<?php echo e(route('competitionathlete.import.excel')); ?>" method="POST"
                            enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <label class="font-weight-bold">Upload Excel File (.xlsx)</label>
                            <input type="file" name="excel" class="form-control mb-2" required accept=".xlsx">

                            <button class="btn btn-success">Upload & Import</button>
                        </form>
                    </div>


                </div>

                <?php if(session('invalidRows')): ?>
                    <div class="alert alert-warning mt-3">
                        <strong>Invalid Rows</strong>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>Row</th>
                                    <th>Competition</th>
                                    <th>Athlete</th>
                                    <th>Group</th>
                                    <th>Error</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = session('invalidRows'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($row['row']); ?></td>
                                        <td><?php echo e($row['competition_name']); ?></td>
                                        <td><?php echo e($row['athlete_name']); ?></td>
                                        <td><?php echo e($row['group_name']); ?></td>
                                        <td><?php echo e($row['error']); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
                <table class="table table-bordered zero-configuration">
                    <thead>
                        <tr>
                            <th>*</th>
                            <th>Competition</th>
                            <th>Athlete</th>
                            <th>Group</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $assignments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                         <td><?php echo e($loop->iteration); ?></td>
                                <td><?php echo e($assign->competition->name ?? '-'); ?></td>
                                <td><?php echo e($assign->athlete->first_name); ?> <?php echo e($assign->athlete->last_name); ?></td>
                                <td><?php echo e($assign->group->name ?? '-'); ?></td>
                                <td>
                                    <a href="<?php echo e(route('competitionathlete.edit', $assign->id)); ?>"
                                        class="btn btn-sm btn-warning">Edit</a>
                                    <form action="<?php echo e(route('competitionathlete.destroy', $assign->id)); ?>" method="POST"
                                        class="d-inline" onsubmit="return confirm('Delete this assignment?')">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('DELETE'); ?>
                                        <button class="btn btn-sm btn-danger">Delete</button>
                                    </form>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                    <tfoot>
                        <tr>
                            <th>*</th>
                            <th>Competition</th>
                            <th>Athlete</th>
                            <th>Group</th>
                            <th>Actions</th>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/js/scripts/datatables/datatable.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/competition_athlete/index.blade.php ENDPATH**/ ?>