

<?php $__env->startSection('content'); ?>
    <div class="container py-4">
        <h3 class="mb-3"><?php echo e($competition->name ?? 'Competition'); ?> — Club Registration</h3>

        
        <?php if(session('status')): ?>
            <div class="alert alert-success"><?php echo e(session('status')); ?></div>
        <?php endif; ?>

        
        <form method="get" action="<?php echo e(route('ownerclub.competition.registration', $competition)); ?>"
            class="row g-2 align-items-end mb-3">
            <div class="col-md-4">
                <label class="form-label">Age Category (by YOB)</label>
                <select name="age_category_id" class="form-select" onchange="this.form.submit()">
                    <?php $__currentLoopData = $ageCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ac): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($ac->id); ?>" <?php echo e($ac->id == $ageCategoryId ? 'selected' : ''); ?>>
                            <?php echo e($ac->name); ?> (<?php echo e($ac->year_from); ?>–<?php echo e($ac->year_to); ?>)
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>
            <div class="col-md-8 text-end">
                <div class="d-inline-block me-2">
                    <span class="badge bg-success">Selected: <?php echo e($selectedCount); ?></span>
                </div>
                <div class="d-inline-block me-2">
                    <span class="badge bg-secondary">Unselected: <?php echo e($unselectedCount); ?></span>
                </div>
                <a class="btn btn-outline-primary"
                    href="<?php echo e(route('ownerclub.competition.registration.export', [$competition, 'age_category_id' => $ageCategoryId])); ?>">
                    Export Excel/CSV
                </a>
            </div>
        </form>

        
        <div class="mb-3">
            <form method="post" action="<?php echo e(route('ownerclub.competition.registration.selectAll', $competition)); ?>"
                class="d-inline">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="age_category_id" value="<?php echo e($ageCategoryId); ?>">
                <button class="btn btn-sm btn-success">Select All</button>
            </form>
            <form method="post" action="<?php echo e(route('ownerclub.competition.registration.clearAll', $competition)); ?>"
                class="d-inline ms-2">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="age_category_id" value="<?php echo e($ageCategoryId); ?>">
                <button class="btn btn-sm btn-outline-secondary">Clear All</button>
            </form>
        </div>

        
        <form method="post" action="<?php echo e(route('ownerclub.competition.registration.save', $competition)); ?>">
            <?php echo csrf_field(); ?>
            <input type="hidden" name="age_category_id" value="<?php echo e($ageCategoryId); ?>">

            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <span>Athletes</span>
                    <div>
                        <input class="form-check-input" type="checkbox" id="checkAll" onclick="toggleAll(this)">
                        <label for="checkAll" class="ms-1">Toggle All</label>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-sm align-middle mb-0">
                        <thead>
                            <tr>
                                <th style="width:40px;"></th>
                                <th>Name</th>
                                <th>YOB</th>
                                <th>Group (if generated)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $eligibleAthletes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <?php
                                    $row = $existing[$a->id] ?? null;
                                    $isSelected = $row?->selected ?? false;
                                    $groupName = optional($row?->group)->name;
                                ?>
                                <tr>
                                    <td>
                                        <input type="checkbox" name="athlete_ids[]" value="<?php echo e($a->id); ?>"
                                            <?php echo e($isSelected ? 'checked' : ''); ?>>
                                    </td>
                                    <td><?php echo e($a->last_name); ?>, <?php echo e($a->first_name); ?></td>
                                    <td><?php echo e($a->yob); ?></td>
                                    <td><?php echo e($groupName ?? '—'); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="text-muted">No eligible athletes for this age category.</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer text-end">
                    <button class="btn btn-primary">Save Selections</button>
                </div>
            </div>
        </form>

        
        <div class="card mt-4">
            <div class="card-header">Apparatus Rotation (Admin Generated)</div>
            <div class="table-responsive">
                <table class="table table-sm mb-0">
                    <thead>
                        <tr>
                            <th>Round</th>
                            <th>Group</th>
                            <?php $__currentLoopData = $apparatus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <th><?php echo e(strtoupper($app->name)); ?></th>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $rotations->groupBy('round_number'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $round => $rows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <td><?php echo e($round); ?></td>
                                <td>
                                    <?php echo e($rows->first()->group->name ?? '—'); ?>

                                </td>
                                <?php $__currentLoopData = $apparatus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $hit = $rows->firstWhere('apparatus_id', $app->id);
                                    ?>
                                    <td><?php echo e($hit ? '●' : ''); ?></td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="<?php echo e(2 + $apparatus->count()); ?>" class="text-muted">No rotations yet.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script>
        function toggleAll(master) {
            document.querySelectorAll('input[name="athlete_ids[]"]').forEach(cb => cb.checked = master.checked);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/ownerclub/competition/registration.blade.php ENDPATH**/ ?>