

<?php $__env->startSection('judge_content'); ?>
<style>
  input.form-control { border:1px solid #bdbdbd !important; background:#fff !important; }
  input.form-control:focus { box-shadow:0 0 0 0.2rem rgba(0,123,255,.25); border-color:#007bff; }
  label { font-weight:600; color:#333; }
  .athlete-big { width:80px; height:80px; object-fit:cover; }
</style>

<div class="card">
  <div class="card-header d-flex justify-content-between align-items-center">
    <h4 class="mb-0">
      Round <?php echo e($currentRound); ?> – <?php echo e($rotation->apparatus->name); ?>

      – Group <?php echo e($rotation->group->name ?? $rotation->group_id); ?>

    </h4>
    <a href="<?php echo e(route('judge.round.athletes')); ?>" class="btn btn-link">← Back to list</a>
  </div>

  <div class="card-body">
    <?php if($errors->any()): ?>
      <div class="alert alert-danger">
        <ul class="mb-0">
          <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($e); ?></li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
      </div>
    <?php endif; ?>
    <div class="media mb-3">
      <img src="<?php echo e(asset($entry->athlete->photo_url) ?? asset('images/athlete_placeholder.png')); ?>" class="mr-3 rounded athlete-big">
      <div class="media-body">
        <h5 class="mt-0"><?php echo e($entry->athlete->first_name); ?> <?php echo e($entry->athlete->last_name); ?></h5>
        <div class="text-muted"><?php echo e($entry->athlete->club_name ?? '—'); ?></div>
      </div>
    </div>

    <form method="POST" action="<?php echo e(route('judge.round.athletes.submit', $entry->athlete_id)); ?>">
      <?php echo csrf_field(); ?>

      <div class="form-row">
        <div class="form-group col-md-2">
          <label>E1</label>
          <input type="number" name="e1_score" class="form-control" required min="0" max="10" step="0.1" value="<?php echo e(old('e1_score', 0)); ?>">
        </div>
        <div class="form-group col-md-2">
          <label>E2</label>
          <input type="number" name="e2_score" class="form-control" min="0" max="10" step="0.1" value="<?php echo e(old('e2_score')); ?>">
        </div>
        <div class="form-group col-md-2">
          <label>E3</label>
          <input type="number" name="e3_score" class="form-control" min="0" max="10" step="0.1" value="<?php echo e(old('e3_score')); ?>">
        </div>
        <div class="form-group col-md-2">
          <label>E4</label>
          <input type="number" name="e4_score" class="form-control" min="0" max="10" step="0.1" value="<?php echo e(old('e4_score')); ?>">
        </div>
        <div class="form-group col-md-2">
          <label>CR</label>
          <input type="number" name="cr_score" class="form-control" required min="0" max="10" step="0.1" value="<?php echo e(old('cr_score', 0)); ?>">
        </div>
        <div class="form-group col-md-2">
          <label>ND</label>
          <input type="number" name="nd_score" class="form-control" required min="0" max="99.99" step="0.01" value="<?php echo e(old('nd_score', 0)); ?>">
        </div>
      </div>

      <div class="form-row">
        <div class="form-group col-md-3">
          <label>D (click)</label>
          <?php if($entry->competition?->scoring_type === 'FIG'): ?>
            <input type="text" class="form-control d-score-input" name="d_score" required readonly placeholder="D">
          <?php else: ?>
            <input type="number" class="form-control" name="d_score" step="0.1" min="0" max="10" placeholder="Enter D Score" value="<?php echo e(old('d_score', 0)); ?>">
          <?php endif; ?>
        </div>
        <div class="form-group col-md-3">
          <label>Bonus</label>
          <input type="number" name="bonus" class="form-control" min="0" max="10" step="0.1" value="<?php echo e(old('bonus', 0)); ?>">
        </div>
      </div>

      <button class="btn btn-success btn-block">Submit & Lock Athlete</button>
    </form>
  </div>
</div>


<div class="modal fade" id="dScoreModal" tabindex="-1" role="dialog" aria-labelledby="dScoreModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg" role="document">
    <div class="modal-content border-0 shadow">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">Calculate D Score (Difficulty)</h5>
        <button type="button" class="close text-white" data-dismiss="modal"><span>&times;</span></button>
      </div>
      <div class="modal-body pb-1">
        <div class="row">
          <?php
            $letters = ['a'=>0.1,'b'=>0.2,'c'=>0.3,'d'=>0.4,'e'=>0.5,'f'=>0.6,'g'=>0.7,'h'=>0.8,'i'=>0.9,'j'=>1.0];
          ?>
          <?php $__currentLoopData = $letters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $letter => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-2 col-4 text-center mb-3">
              <label class="text-uppercase font-weight-bold"><?php echo e($letter); ?><br><small><?php echo e($value); ?></small></label>
              <input type="number" class="form-control element-input" data-value="<?php echo e($value); ?>" data-letter="<?php echo e($letter); ?>" min="0" max="10" step="1" value="0">
            </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <div class="text-right mt-3">
          <h5>Total D Score: <span id="calculatedDScore" class="text-success font-weight-bold">0.00</span></h5>
        </div>
      </div>
      <div class="modal-footer bg-light">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        <button type="button" id="applyDScoreBtn" class="btn btn-success">Apply D Score</button>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script>
  let currentDInput = null;

  // Open modal on D input click
  $(document).on('click', '.d-score-input', function() {
    currentDInput = $(this);
    $('#dScoreModal').modal('show');
    $('#calculatedDScore').text('0.00');
    $('.element-input').val(0);
  });

  // Live calculation of D score
  $(document).on('input', '.element-input', function() {
    let total = 0;
    $('.element-input').each(function() {
      const count = parseFloat($(this).val()) || 0;
      const value = parseFloat($(this).data('value'));
      total += count * value;
    });
    $('#calculatedDScore').text(total.toFixed(2));
  });

  // Apply calculated score
  $('#applyDScoreBtn').on('click', function() {
    const total = parseFloat($('#calculatedDScore').text());
    if (currentDInput) currentDInput.val(total.toFixed(2));
    $('#dScoreModal').modal('hide');
  });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('judge.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/judge/round/athlete_form.blade.php ENDPATH**/ ?>