
<?php
    $style = $template->style ?? [];
?>
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <style>
        @page {
            margin: 0;
        }

        body {
            margin: 0;
            font-family: DejaVu Sans, sans-serif;
        }

        .page {
            position: relative;
            width: 100%;
            height: 100vh;
        }

        .bg {
            position: absolute;
            inset: 0;
        }

        .center {
            position: absolute;
            left: 0;
            right: 0;
            text-align: center;
        }
    </style>
</head>

<body>
    <?php $__currentLoopData = $athletes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $athlete): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="page">
            <img class="bg" src="<?php echo e(public_path( $template->background_path)); ?>"
                style="width: 100%; height: 100%; object-fit: cover;" />
            <div class="center" style="top: 15%;">
                <div style="font-size: <?php echo e($style['title_font'] ?? 28); ?>px; font-weight: bold;"><?php echo e($template->title); ?>

                </div>
                <?php if(data_get($template->custom_fields, 'subtitle')): ?>
                    <div style="font-size: <?php echo e($style['subtitle_font'] ?? 18); ?>px;">
                        <?php echo e(data_get($template->custom_fields, 'subtitle')); ?></div>
                <?php endif; ?>
            </div>


            <div class="center" style="top: 45%;">
                <div style="font-size: <?php echo e($style['name_font'] ?? 42); ?>px; font-weight: 800;"><?php echo e($athlete->first_name); ?>

                    <?php echo e($athlete->last_name); ?></div>
                <div style="font-size: 16px;"><?php echo e($competition->title ?? 'Competition #' . $competition->id); ?></div>
            </div>


            <?php if(data_get($template->custom_fields, 'footer')): ?>
                <div class="center" style="bottom: 6%; font-size: 14px;">
                    <?php echo e(data_get($template->custom_fields, 'footer')); ?></div>
            <?php endif; ?>
        </div>
        <?php if(!$loop->last): ?>
            <div style="page-break-after: always;"></div>
        <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</body>

</html>
<?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/certificates/pdf.blade.php ENDPATH**/ ?>