<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h4 class="card-title">Edit Athlete Assignment</h4>
    </div>

    <div class="card-body">
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <strong>Please correct the following:</strong>
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('competitionathlete.update', $assignment->id)); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-md-6 mb-2">
                    <label>Competition</label>
                    <select name="competition_id" class="form-control" required>
                        <?php $__currentLoopData = $competitions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $competition): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($competition->id); ?>" <?php echo e($assignment->competition_id == $competition->id ? 'selected' : ''); ?>>
                                <?php echo e($competition->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-md-6 mb-2">
                    <label>Athlete</label>
                    <select name="athlete_id" class="form-control" required>
                        <?php $__currentLoopData = $athletes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $athlete): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($athlete->id); ?>" <?php echo e($assignment->athlete_id == $athlete->id ? 'selected' : ''); ?>>
                                <?php echo e($athlete->first_name); ?> <?php echo e($athlete->last_name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-md-6 mb-2">
                    <label>Group</label>
                    <select name="group_id" class="form-control">
                        <option value="">(None)</option>
                        <?php $__currentLoopData = $groups; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $group): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($group->id); ?>" <?php echo e($assignment->group_id == $group->id ? 'selected' : ''); ?>>
                                <?php echo e($group->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="mt-2">
                <button class="btn btn-primary">Update</button>
                <a href="<?php echo e(route('competitionathlete.index')); ?>" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const competitionSelect = document.querySelector('select[name="competition_id"]');
    const groupSelect = document.querySelector('select[name="group_id"]');
    const currentGroupId = '<?php echo e($assignment->group_id); ?>';

    function loadGroups(competitionId, preselectGroupId = null) {
        groupSelect.innerHTML = '<option value="">(None)</option>';

        if (competitionId) {
            fetch(`/get-competition-groups/${competitionId}`)
                .then(response => response.json())
                .then(groups => {
                    groups.forEach(group => {
                        const option = document.createElement('option');
                        option.value = group.id;
                        option.textContent = group.name;
                        if (preselectGroupId && group.id == preselectGroupId) {
                            option.selected = true;
                        }
                        groupSelect.appendChild(option);
                    });
                })
                .catch(error => {
                    console.error('Error fetching groups:', error);
                });
        }
    }

    // On page load → load groups for preselected competition
    if (competitionSelect.value) {
        loadGroups(competitionSelect.value, currentGroupId);
    }

    // On change → reload groups
    competitionSelect.addEventListener('change', function () {
        loadGroups(this.value);
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/competition_athlete/edit.blade.php ENDPATH**/ ?>