

<?php $__env->startSection('content'); ?>
<div class="container py-5">
    <h3 class="mb-4">Club Registration — Select Age & Competition</h3>

    <?php if($errors->any()): ?>
        <div class="alert alert-danger">
            <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($e); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>

    <form method="post" action="<?php echo e(route('ownerclub.registration.go')); ?>" class="card p-4 shadow-sm">
        <?php echo csrf_field(); ?>

        <div class="row g-3">
            <div class="col-md-6">
                <label class="form-label">Age Category</label>
                <select name="age_category_id" class="form-control" required>
                    <option value="" disabled selected>Choose age category…</option>
                    <?php $__currentLoopData = $ageCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ac): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            // If your AgeCategory stores DOB windows in min_age/max_age (YYYY-MM-DD), show years as hint.
                            $hint = '';
                            if (is_string($ac->min_age) && preg_match('/^\d{4}-\d{2}-\d{2}$/',$ac->min_age)
                                && is_string($ac->max_age) && preg_match('/^\d{4}-\d{2}-\d{2}$/',$ac->max_age)) {
                                $hint = substr($ac->min_age,0,4) . '–' . substr($ac->max_age,0,4);
                            } else {
                                $hint = $ac->min_age . '–' . $ac->max_age;
                            }
                        ?>
                        <option value="<?php echo e($ac->id); ?>">
                            <?php echo e($ac->name); ?> (<?php echo e($hint); ?>)
                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col-md-6">
                <label class="form-label">Active Competition</label>
                <select name="competition_id" class="form-control" required>
                    <option value="" disabled selected>Choose active competition…</option>
                    <?php $__empty_1 = true; $__currentLoopData = $competitions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <?php
                            $sd = optional($c->start_date)->toDateString() ?? '';
                            $ed = optional($c->end_date)->toDateString() ?? '';
                            $range = trim(($sd ? $sd : '') . ($ed ? ' – '.$ed : ''));
                        ?>
                        <option value="<?php echo e($c->id); ?>">
                            <?php echo e($c->name); ?> <?php echo e($range ? "($range)" : ''); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <option disabled>No active competitions available</option>
                    <?php endif; ?>
                </select>
            </div>
        </div>

        <div class="text-end mt-4">
            <button class="btn btn-primary">Continue</button>
        </div>
    </form>

    <div class="mt-4 text-muted">
        <small>
            After you select, you’ll be taken to the registration page showing all athletes in the chosen age category,
            with checkboxes to include/exclude them from the selected competition. “Selected” means a row exists in
            <code>competition_athlete</code> for that athlete & competition.
        </small>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/ownerclub/competition/selector.blade.php ENDPATH**/ ?>