

<?php $__env->startSection('judge_content'); ?>
    <style>
        input.form-control {
            border: 1px solid #bdbdbd !important;
            background: #fff !important;
        }
        input.form-control:focus {
            box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, .25);
            border-color: #007bff;
        }
        label { font-weight: 600; color: #333; }
        .athlete-photo { width: 64px; height: 64px; object-fit: cover; }
        .small-note { font-size: .85rem; color: #6c757d; }
    </style>

    <?php
        // Safe accessors when rotation may be null (e.g., Vault 2 list)
        $apparatusName = ($isVault2 ?? false)
            ? 'Vault 2 (Qualification)'
            : optional(optional($rotation)->apparatus)->name;

        $groupLabel = optional(optional($rotation)->group)->name
            ?? (optional($rotation)->group_id ?? '—');

        // Try to resolve competition for V2 POST route if not passed
        $competitionForV2 = $competition ?? (\App\Models\Competition::find(session('competition_id')));
    ?>

    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center flex-wrap">
            <h4 class="mb-2 mb-md-0">
                <?php if(!empty($isVault2) && $isVault2): ?>
                    <?php echo e($apparatusName); ?>

                    <?php if($groupLabel !== '—'): ?>
                        – Group <?php echo e($groupLabel); ?>

                    <?php endif; ?>
                    <span class="badge badge-warning ml-2">Top-8</span>
                <?php else: ?>
                    Round <?php echo e($currentRound); ?> – <?php echo e($apparatusName ?? 'Apparatus'); ?>

                    – Group <?php echo e($groupLabel); ?>

                <?php endif; ?>
            </h4>

            <form class="form-inline" method="GET"
                  action="<?php echo e(!empty($isVault2) && $isVault2 ? route('judge.vault2.show', $competitionForV2) : route('judge.round.athletes')); ?>">
                <input type="text" name="search" class="form-control mr-2" placeholder="Search athlete/club"
                       value="<?php echo e($search); ?>">
                <button class="btn btn-outline-primary">Search</button>
            </form>
        </div>

        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
                </div>
            <?php endif; ?>
            <?php if(session('warning')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('warning')); ?>

                    <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
                </div>
            <?php endif; ?>

            <div class="row">
                <?php $__empty_1 = true; $__currentLoopData = $entries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $entry): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <?php
                        $ath = $entry->athlete ?? $entry; // V2 entries may be plain athletes via join; fallback
                        $athId = $ath->id ?? $entry->athlete_id ?? null;
                        $entered = $athId ? in_array($athId, $enteredById, true) : false;

                        $name = trim(($ath->first_name ?? '') . ' ' . ($ath->last_name ?? ''));
                        $initials = collect(explode(' ', $name))
                            ->filter()
                            ->map(fn($w) => mb_strtoupper(mb_substr($w, 0, 1)))
                            ->take(2)
                            ->implode('');
                        $bg = '#e9ecef'; $fg = '#6c757d';
                        $svg = <<<SVG
                        <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" role="img" aria-label="{$initials}">
                          <rect width="100%" height="100%" fill="{$bg}"/>
                          <text x="50%" y="52%" text-anchor="middle" dominant-baseline="middle"
                                font-family="Arial, Helvetica, sans-serif" font-weight="700" font-size="24" fill="{$fg}">
                            {$initials}
                          </text>
                        </svg>
                        SVG;
                        $svgDataUri = 'data:image/svg+xml;charset=UTF-8,' . rawurlencode($svg);
                        $photo = asset($ath->photo_url) ?? '';
                        $cardId = 'athlete-'.$athId;
                    ?>

                    
                    <div class="col-md-6 col-lg-4 mb-3">
                        <div class="card h-100 shadow-sm">
                            <div class="card-body d-flex">
                                <img src="<?php echo e($photo ?: $svgDataUri); ?>"
                                     onerror="this.onerror=null;this.src='<?php echo e($svgDataUri); ?>';"
                                     class="rounded athlete-photo mr-3" alt="<?php echo e($name ?: 'Athlete'); ?>" width="64" height="64" />

                                <div class="flex-fill">
                                    <div class="d-flex justify-content-between align-items-start">
                                        <h5 class="mb-1"><?php echo e($name ?: '—'); ?></h5>
                                        <span class="badge badge-<?php echo e($entered ? 'success' : 'secondary'); ?>">
                                            <?php echo e($entered ? 'Entered' : 'Pending'); ?>

                                        </span>
                                    </div>
                                    <div class="text-muted"><?php echo e(optional($ath->club)->name ?? ($ath->club_name ?? '—')); ?></div>

                                    <?php if(!empty($isVault2) && $isVault2): ?>
                                        <div class="small-note mt-1">Vault 2 scoring — Top-8 from Vault 1</div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="card-footer bg-white">
                                <?php if($entered): ?>
                                    <button class="btn btn-outline-secondary btn-block" disabled>Locked</button>
                                <?php else: ?>
                                    <?php if(!empty($isVault2) && $isVault2): ?>
                                        
                                        <button class="btn btn-primary btn-block" type="button" data-toggle="collapse"
                                                data-target="#form-<?php echo e($cardId); ?>">Enter Vault 2 score</button>

                                        <div id="form-<?php echo e($cardId); ?>" class="collapse mt-3">
                                            <form method="POST"
                                                  action="<?php echo e(route('judge.vault2.store', [$competitionForV2, $athId])); ?>">
                                                <?php echo csrf_field(); ?>
                                                <div class="form-row">
                                                    <div class="form-group col-4">
                                                        <label class="mb-0">D</label>
                                                        <input type="number" step="0.1" min="0" max="10" name="d_score" class="form-control" required>
                                                    </div>
                                                    <div class="form-group col-4">
                                                        <label class="mb-0">E1</label>
                                                        <input type="number" step="0.1" min="0" max="10" name="e1_score" class="form-control">
                                                    </div>
                                                    <div class="form-group col-4">
                                                        <label class="mb-0">E2</label>
                                                        <input type="number" step="0.1" min="0" max="10" name="e2_score" class="form-control">
                                                    </div>
                                                    <div class="form-group col-4">
                                                        <label class="mb-0">E3</label>
                                                        <input type="number" step="0.1" min="0" max="10" name="e3_score" class="form-control">
                                                    </div>
                                                    <div class="form-group col-4">
                                                        <label class="mb-0">E4</label>
                                                        <input type="number" step="0.1" min="0" max="10" name="e4_score" class="form-control">
                                                    </div>
                                                    <div class="form-group col-4">
                                                        <label class="mb-0">CR</label>
                                                        <input type="number" step="0.1" min="0" max="10" name="cr_score" class="form-control">
                                                    </div>
                                                    <div class="form-group col-6">
                                                        <label class="mb-0">Bonus</label>
                                                        <input type="number" step="0.1" min="0" max="10" name="bonus" class="form-control">
                                                    </div>
                                                    <div class="form-group col-6">
                                                        <label class="mb-0">ND</label>
                                                        <input type="number" step="0.1" min="0" max="99.99" name="nd_score" class="form-control">
                                                    </div>
                                                </div>
                                                <button class="btn btn-success btn-block">Save Vault 2 score</button>
                                            </form>
                                        </div>
                                    <?php else: ?>
                                        
                                        <a href="<?php echo e(route('judge.round.athletes.form', $athId)); ?>" class="btn btn-primary btn-block">
                                            Enter score
                                        </a>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <div class="col-12">
                        <div class="alert alert-info mb-0">
                            <?php if(!empty($isVault2) && $isVault2): ?>
                                No eligible athletes from your group in the Top-8.
                            <?php else: ?>
                                No athletes found.
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <div class="d-flex justify-content-center">
                <?php echo e($entries->links()); ?>

            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('judge.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/judge/round/athletes.blade.php ENDPATH**/ ?>