<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">Edit Athlete</h4>
        </div>
        <div class="card-body">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <strong>There were some problems with your input:</strong>
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            <form action="<?php echo e(route('athletes.update', $athlete->id)); ?>" method="POST" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?> <!-- important for update routes -->

                <div class="row">
                    <div class="col-md-6 mb-2">
                        <label>First Name</label>
                        <input type="text" name="first_name" class="form-control"
                            value="<?php echo e(old('first_name', $athlete->first_name)); ?>" required>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label>Last Name</label>
                        <input type="text" name="last_name" class="form-control"
                            value="<?php echo e(old('last_name', $athlete->last_name)); ?>">
                    </div>

                    <div class="col-md-6 mb-2 d-flex align-items-center">
                        <div class="w-75">
                            <label for="photo_url">Upload New Photo</label>
                            <input type="file" name="photo_url" class="form-control">
                            <small class="text-muted">Leave empty to keep current photo.</small>
                        </div>

                        <?php if($athlete->photo_url): ?>
                            <div class="ml-3">
                                <img src="<?php echo e(asset($athlete->photo_url)); ?>" alt="Athlete Photo" class="rounded border"
                                    width="80" height="80" style="object-fit: cover;">
                            </div>
                        <?php endif; ?>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label>Gender</label>
                        <select name="gender" class="form-control" required>
                            <option value="">Select Gender</option>
                            <option value="male" <?php echo e(old('gender', $athlete->gender) == 'male' ? 'selected' : ''); ?>>Male
                            </option>
                            <option value="female" <?php echo e(old('gender', $athlete->gender) == 'female' ? 'selected' : ''); ?>>
                                Female</option>
                        </select>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label>Date of Birth</label>
                        <input type="date" name="dob" class="form-control"
                            value="<?php echo e(old('dob', optional($athlete->dob)->format('Y-m-d'))); ?>">
                    </div>

                    <div class="col-md-6 mb-2">
                        <label>Club</label>
                        <select name="club_id" class="form-control">
                            <option value="">Select Club</option>
                            <?php $__currentLoopData = $clubs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $club): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($club->id); ?>"
                                    <?php echo e(old('club_id', $athlete->club_id) == $club->id ? 'selected' : ''); ?>>
                                    <?php echo e($club->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label>Type</label>
                        <select name="type" class="form-control">
                            <option value="">Select Type</option>
                            <option value="Club" <?php echo e(old('type', $athlete->type) == 'Club' ? 'selected' : ''); ?>>Club
                            </option>
                            <option value="Academy" <?php echo e(old('type', $athlete->type) == 'Academy' ? 'selected' : ''); ?>>
                                Academy</option>
                            <option value="FIG" <?php echo e(old('type', $athlete->type) == 'FIG' ? 'selected' : ''); ?>>FIG
                            </option>
                        </select>
                    </div>
                    <div class="col-md-6 mb-2">
                        <label>Country</label>
                        <select name="country_id" class="form-control">
                            <option value="">Select Country</option>
                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($country->id); ?>"
                                    <?php echo e(old('country_id', $athlete->country_id) == $country->id ? 'selected' : ''); ?>>
                                    <?php echo e($country->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label>Age Category</label>
                        <select name="age_category_id" class="form-control">
                            <option value="">Select Age Category</option>
                            <?php $__currentLoopData = $ageCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($cat->id); ?>"
                                    <?php echo e(old('age_category_id', $athlete->age_category_id) == $cat->id ? 'selected' : ''); ?>>
                                    <?php echo e($cat->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label>Level</label>
                        <select name="level_id" class="form-control">
                            <option value="">Select Level</option>
                            <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($level->id); ?>"
                                    <?php echo e(old('level_id', $athlete->level_id) == $level->id ? 'selected' : ''); ?>>
                                    <?php echo e($level->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-md-6 mb-2">
                        <label>Category</label>
                        <select name="category_id" class="form-control">
                            <option value="">Select Category</option>
                            <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->id); ?>"
                                    <?php echo e(old('category_id', $athlete->category_id) == $category->id ? 'selected' : ''); ?>>
                                    <?php echo e($category->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>

                <div class="mt-2">
                    <button class="btn btn-primary">Update</button>
                    <a href="<?php echo e(route('athletes.index')); ?>" class="btn btn-secondary">Cancel</a>
                </div>
            </form>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/athletes/edit.blade.php ENDPATH**/ ?>