<?php $__env->startSection('judge_content'); ?>
    <?php $__empty_1 = true; $__currentLoopData = $rounds; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $roundNumber => $rotations): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="card mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h4>Main Judge Overview – Round <?php echo e($roundNumber); ?></h4>

                <?php if($rotations->every(fn($r) => $r->status === 'active')): ?>
                    <form id="complete-round-form-<?php echo e($roundNumber); ?>"
                        action="<?php echo e(route('main_judge.completeRound', $roundNumber)); ?>" method="POST" style="display: none;">
                        <?php echo csrf_field(); ?>
                    </form>

                    <button class="btn btn-success btn-sm" onclick="confirmCompleteRound(<?php echo e($roundNumber); ?>)">
                        ✅ Mark Round <?php echo e($roundNumber); ?> as Complete
                    </button>
                <?php endif; ?>
            </div>

            <div class="card-body">
                <?php $__currentLoopData = $rotations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rotation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="mb-4">
                        <h5 class="mb-1">
                            Group: <?php echo e($rotation->group->name ?? '-'); ?> |
                            Apparatus: <?php echo e($rotation->apparatus->name ?? '-'); ?>

                            <span class="badge badge-<?php echo e($rotation->status === 'completed' ? 'success' : 'warning'); ?>">
                                <?php echo e(ucfirst($rotation->status)); ?>

                            </span>
                        </h5>

                        <?php
                            $scores = \App\Models\Score::with(['athlete', 'judge'])
                                ->where('competition_id', $rotation->competition_id)
                                ->where('group_id', $rotation->group_id)
                                ->where('apparatus_id', $rotation->apparatus_id)
                                ->where('round_number', $rotation->round_number)
                                ->get();
                        ?>

                        <?php if($scores->isEmpty()): ?>
                            <p class="text-muted">No scores submitted yet.</p>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>#</th>
                                            <th>Athlete Name</th>
                                            <th>D</th>
                                            <th>E1</th>
                                            <th>E2</th>
                                            <th>E3</th>
                                            <th>E4</th>
                                            <th>Bonus</th>
                                            <th>CR</th>
                                            <th>ND</th>
                                            <th>Final</th>
                                            <th>Judge</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $scores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $score): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($i + 1); ?></td>
                                                <td><?php echo e($score->athlete->first_name); ?> <?php echo e($score->athlete->last_name); ?>

                                                </td>

                                                <?php $disabled = $rotation->status === 'completed' ? 'disabled' : ''; ?>

                                                <?php $__currentLoopData = ['d_score', 'e1_score', 'e2_score', 'e3_score', 'e4_score', 'bonus', 'cr_score', 'nd_score']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <td>
                                                        <input type="number" step="0.1"
                                                            class="form-control form-control-sm ajax-score-input"
                                                            data-field="<?php echo e($field); ?>"
                                                            data-score-id="<?php echo e($score->id); ?>"
                                                            value="<?php echo e($score->$field); ?>" style="width: 80px;"
                                                            <?php echo e($disabled); ?>>
                                                    </td>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                <td><strong><?php echo e($score->final_score); ?></strong></td>
                                                <td><?php echo e($score->judge->first_name ?? '—'); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="card">
            <div class="card-body">
                <p>No rounds found for this competition.</p>
            </div>
        </div>
    <?php endif; ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        function confirmCompleteRound(roundNumber) {
            Swal.fire({
                title: `Mark Round ${roundNumber} as Complete?`,
                text: "This action will finalize the current round.",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#28a745',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, mark complete'
            }).then((result) => {
                if (result.isConfirmed) {
                    document.getElementById('complete-round-form-' + roundNumber).submit();
                }
            });
        }
    </script>
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 2000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        });

        const inputs = document.querySelectorAll('.ajax-score-input');

        inputs.forEach(input => {
            input.addEventListener('change', function () {
                const field = this.dataset.field;
                const scoreId = this.dataset.scoreId;
                const value = this.value;

                fetch(`/scores/${scoreId}/update-field`, {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                    },
                    body: JSON.stringify({ field, value })
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        Toast.fire({
                            icon: 'success',
                            title: data.message
                        });
                    } else {
                        Toast.fire({
                            icon: 'error',
                            title: data.message || 'Failed to update.'
                        });
                    }
                })
                .catch(() => {
                    Toast.fire({
                        icon: 'error',
                        title: 'An error occurred while saving.'
                    });
                });
            });
        });
    });
</script>


<?php $__env->stopSection(); ?>

<?php echo $__env->make('judge.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/judge/round/main_view.blade.php ENDPATH**/ ?>