<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/vendors/css/vendors.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/buttons.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section id="athlete-datatable">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="card-title mb-0">Athletes</h4>
                        <div>
                            <a href="<?php echo e(route('athletes.create')); ?>" class="btn btn-primary mr-2">
                                <i class="bx bx-plus"></i> Add Athlete
                            </a>
                            <button class="btn btn-outline-success" data-toggle="modal" data-target="#importAthleteModal">
                                <i class="bx bx-upload"></i> Import Athletes
                            </button>
                        </div>
                    </div>
                    <?php if(session('import_errors') && count(session('import_errors')) > 0): ?>
                        <div class="alert alert-warning mt-3">
                            <h5 class="alert-heading">
                                Some rows were not imported (<?php echo e(count(session('import_errors'))); ?> rows)
                            </h5>
                            <p class="mb-2">Please review the errors below, fix the file, and try again only for those
                                athletes if needed.</p>

                            <div class="table-responsive">
                                <table class="table table-sm table-bordered">
                                    <thead class="thead-light">
                                        <tr>
                                            <th>Row</th>
                                            <th>Athlete</th>
                                            <th>Errors</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = session('import_errors'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $errorRow): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($errorRow['row']); ?></td>
                                                <td>
                                                    <?php echo e($errorRow['data']['first_name'] ?? ''); ?>

                                                    <?php echo e($errorRow['data']['last_name'] ?? ''); ?>

                                                </td>
                                                <td>
                                                    <ul class="mb-0">
                                                        <?php $__currentLoopData = $errorRow['errors']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $msg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <li><?php echo e($msg); ?></li>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </ul>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="card-body card-dashboard">
                        <div class="table-responsive">
                            <table class="table zero-configuration">
                                <thead>
                                    <tr>
                                        <th>*</th>
                                        <th>First Name</th>
                                        <th>Last Name</th>
                                        <th>Image</th>
                                        <th>Gender</th>
                                        <th>DOB</th>
                                        <th>Club</th>
                                        <th>Type</th>
                                        <th>Country</th>
                                        <th>Age Category</th>
                                        <th>Level</th>
                                        <th>Category</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $athletes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $athlete): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($athlete->id); ?></td>
                                            <td><?php echo e($athlete->first_name); ?></td>
                                            <td><?php echo e($athlete->last_name ?? '-'); ?></td>
                                            <td><img src="<?php echo e(asset($athlete->photo_url)); ?>" alt="Athlete Photo"
                                                    class="rounded border" width="80" height="80"
                                                    style="object-fit: cover;"></td>
                                            <td><?php echo e(ucfirst($athlete->gender)); ?></td>
                                            <td><?php echo e($athlete->dob ? $athlete->dob->format('Y-m-d') : '-'); ?></td>
                                            <td><?php echo e($athlete->club?->name ?? '-'); ?></td>
                                            <td><?php echo e($athlete->type ?? '-'); ?></td>
                                            <td><?php echo e($athlete->country?->name ?? '-'); ?></td>
                                            <td><?php echo e($athlete->ageCategory?->name ?? '-'); ?></td>
                                            <td><?php echo e($athlete->level?->name ?? '-'); ?></td>
                                            <td><?php echo e($athlete->category?->name ?? '-'); ?></td>
                                            <td>
                                                <a href="<?php echo e(route('athletes.edit', $athlete->id)); ?>"
                                                    class="btn btn-sm btn-warning">Edit</a>
                                                <button type="button" class="btn btn-sm btn-danger btn-delete"
                                                    data-url="<?php echo e(route('athletes.destroy', $athlete->id)); ?>">
                                                    Delete
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>

                                <tfoot>
                                    <tr>
                                        <th>*</th>
                                        <th>First Name</th>
                                        <th>Last Name</th>
                                        <th>Image</th>
                                        <th>Gender</th>
                                        <th>DOB</th>
                                        <th>Club</th>
                                        <th>Country</th>
                                        <th>Age Category</th>
                                        <th>Level</th>
                                        <th>Category</th>
                                        <th>Actions</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Import Athletes Modal -->
        <div class="modal fade" id="importAthleteModal" tabindex="-1" role="dialog"
            aria-labelledby="importAthleteModalLabel" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <form action="<?php echo e(route('athletes.import')); ?>" method="POST" enctype="multipart/form-data"
                    class="modal-content">
                    <?php echo csrf_field(); ?>
                    <div class="modal-header">
                        <h5 class="modal-title" id="importAthleteModalLabel">Import Athletes</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <a href="<?php echo e(asset('Athlete.xlsx')); ?>" class="btn btn-sm btn-info">Download Sample File</a>

                        <div class="form-group">
                            <label for="importFile">Select CSV or Excel file</label>
                            <input type="file" name="file" id="importFile" class="form-control" required>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        <button type="submit" class="btn btn-success"><i class="bx bx-upload"></i> Import</button>
                    </div>
                </form>
            </div>
        </div>
    <?php $__env->stopSection(); ?>

    <?php $__env->startSection('js'); ?>
        <!-- BEGIN: Page Vendor JS-->
        <script src="<?php echo e(asset('app-assets/vendors/js/ui/jquery.sticky.js')); ?>"></script>
        <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js')); ?>"></script>
        <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/dataTables.bootstrap4.min.js')); ?>"></script>
        <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/dataTables.buttons.min.js')); ?>"></script>
        <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js')); ?>"></script>
        <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js')); ?>"></script>
        <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap4.min.js')); ?>"></script>
        <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js')); ?>"></script>
        <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js')); ?>"></script>
        <!-- END: Page Vendor JS-->



        <!-- BEGIN: Page JS-->
        <script src="<?php echo e(asset('app-assets/js/scripts/datatables/datatable.js')); ?>"></script>
        <!-- END: Page JS-->
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/athletes/index.blade.php ENDPATH**/ ?>