<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/vendors/css/vendors.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/buttons.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section id="assign-apparatus-datatable">
        <div class="row">
            <div class="col-12">
                <div class="card">

                    <div class="card-body">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h4 class="card-title mb-0">Assign Apparatus</h4>
                           <div>
                             <a href="<?php echo e(route('assignapparatus.create')); ?>" class="btn btn-primary">
                                <i class="bx bx-plus"></i> Add Assign Apparatus
                            </a>
                            <button class="btn btn-outline-success" data-toggle="modal" data-target="#importAthleteModal">
                                <i class="bx bx-upload"></i> Import Assign Apparatus
                            </button>
                           </div>
                        </div>
                        
                        <div class="table-responsive">
                            <table class="table zero-configuration">
                                <thead>
                                    <tr>
                                        <th>*</th>
                                        <th>Competition</th>
                                        <th>Judge</th>
                                        <th>Apparatus</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $assignments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $assign): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($assign->id); ?></td>
                                            <td><?php echo e($assign->competition->name ?? '-'); ?></td>
                                            <td><?php echo e($assign->judge?->first_name . ' ' . $assign->judge?->last_name ?? '-'); ?></td>
                                            <td><?php echo e($assign->apparatus->name ?? '-'); ?></td>
                                            <td>
                                                <a href="<?php echo e(route('assignapparatus.edit', $assign->id)); ?>"
                                                    class="btn btn-sm btn-warning">Edit</a>

                                                <form action="<?php echo e(route('assignapparatus.destroy', $assign->id)); ?>"
                                                    method="POST" class="d-inline"
                                                    onsubmit="return confirm('Are you sure you want to delete this assignment?')">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button class="btn btn-sm btn-danger">Delete</button>
                                                </form>
                                            </td>

                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>Competition</th>
                                        <th>Judge</th>
                                        <th>Apparatus</th>
                                        <th>Actions</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>
    <div class="modal fade" id="importAthleteModal" tabindex="-1" role="dialog" aria-labelledby="importAthleteModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document">
            <form action="<?php echo e(route('assignapparatus.import')); ?>" method="POST" enctype="multipart/form-data"
                class="modal-content">
                <?php echo csrf_field(); ?>
                <div class="modal-header">
                    <h5 class="modal-title" id="importAthleteModalLabel">Import Assign Apparatus</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="mb-3 text-start">
                        <a href="<?php echo e(asset('assign_apparatus_template.xlsx')); ?>" class="btn btn-outline-primary btn-sm"
                            target="_blank">
                            📥 Download Template
                        </a>
                    </div>

                    <div class="form-group">
                        <label for="importFile" class="form-label fw-bold">
                            Select CSV or Excel File <span class="text-danger">*</span>
                        </label>
                        <input type="file" name="file" id="importFile" class="form-control" required>
                        <small class="form-text text-muted">
                            Accepted formats: .csv, .xlsx (Please use the provided template)
                        </small>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="submit" class="btn btn-success"><i class="bx bx-upload"></i> Import</button>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <!-- BEGIN: Page Vendor JS-->
    <script src="<?php echo e(asset('app-assets/vendors/js/ui/jquery.sticky.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js')); ?>"></script>
    <!-- END: Page Vendor JS-->

    <!-- BEGIN: Page JS-->
    <script src="<?php echo e(asset('app-assets/js/scripts/datatables/datatable.js')); ?>"></script>
    <!-- END: Page JS-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/assign_apparatus/index.blade.php ENDPATH**/ ?>