<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="card-header">
            <h4 class="card-title">Add Competition</h4>
        </div>
        <div class="card-body">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <strong>There were some problems with your input:</strong>
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            <form action="<?php echo e(route('competitions.store')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label for="name">Competition Name</label>
                    <input type="text" name="name" class="form-control" required value="<?php echo e(old('name')); ?>">
                </div>

                <div class="form-group">
                    <label for="start_date">Start Date</label>
                    <input type="datetime-local" name="start_date" class="form-control" value="<?php echo e(old('start_date')); ?>">
                </div>

                <div class="form-group">
                    <label for="end_date">End Date</label>
                    <input type="datetime-local" name="end_date" class="form-control" value="<?php echo e(old('end_date')); ?>">
                </div>

                <div class="form-group">
                    <label for="location">Location</label>
                    <input type="text" name="location" class="form-control" value="<?php echo e(old('location')); ?>">
                </div>
                <div class="form-group">
                    <label for="scoring_type">Scoring Type</label>
                    <select name="scoring_type" class="form-control" required>
                        <option value="FIG" <?php echo e(old('scoring_type') == 'FIG' ? 'selected' : ''); ?>>FIG</option>
                        <option value="American" <?php echo e(old('scoring_type') == 'American' ? 'selected' : ''); ?>>American</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="gender">Gender</label>
                    <select name="gender" class="form-control" required>
                        <option value="male" <?php echo e(old('gender') == 'male' ? 'selected' : ''); ?>>Male</option>
                        <option value="female" <?php echo e(old('gender') == 'female' ? 'selected' : ''); ?>>Female</option>
                    </select>
                </div>
                <div class="form-group form-check mt-3">
                    <input type="checkbox" name="enable_vault2" id="enable_vault2" class="form-check-input"
                        <?php echo e(old('enable_vault2') ? 'checked' : ''); ?>>
                    <label class="form-check-label" for="enable_vault2">
                        Enable Vault 2
                    </label>
                    <small class="form-text text-muted">
                        When enabled, judges can score a second vault after Vault 1 is completed.
                    </small>
                </div>
                <button type="submit" class="btn btn-primary">Create</button>
                <a href="<?php echo e(route('competitions.index')); ?>" class="btn btn-secondary">Cancel</a>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/competitions/create.blade.php ENDPATH**/ ?>