<?php $__env->startSection('judge_content'); ?>
    <style>
        input.form-control {
            border: 1px solid #bdbdbd !important;
            background-color: #fff !important;
        }

        input.form-control:focus {
            box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, .25);
            border-color: #007bff;
        }

        label {
            font-weight: 600;
            color: #333;
        }
    </style>
    <div class="card">
        <div class="card-header">
            <h4>Round <?php echo e($currentRound); ?> – Score Group <?php echo e($rotation->group->name ?? $rotation->group_id); ?></h4>
        </div>
        <div class="card-body">
            <?php if(session('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <?php echo e(session('success')); ?>

                    <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
                </div>
            <?php endif; ?>
            <?php if(session('warning')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <?php echo e(session('warning')); ?>

                    <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('judge.submitRound')); ?>">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="round_number" value="<?php echo e($currentRound); ?>">
                <input type="hidden" name="group_id" value="<?php echo e($rotation->group_id); ?>">
                <input type="hidden" name="apparatus_id" value="<?php echo e($rotation->apparatus_id); ?>">

                <?php $__currentLoopData = $athletes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $athlete): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="border rounded p-3 mb-4 shadow-sm">
                        <h5 class="mb-3 text-primary">
                            <?php echo e($athlete->athlete->first_name); ?> <?php echo e($athlete->athlete->last_name); ?>

                        </h5>
                        <input type="hidden" name="athletes[<?php echo e($athlete->athlete_id); ?>][athlete_id]"
                            value="<?php echo e($athlete->athlete_id); ?>">

                        <div class="form-row">
                            <div class="form-group col-md-2">
                                <label>E1</label>
                                <input type="number" name="athletes[<?php echo e($athlete->athlete_id); ?>][e1_score]"
                                    class="form-control" required min="0" max="100" step="0.01">
                            </div>
                            <div class="form-group col-md-2">
                                <label>E2</label>
                                <input type="number" name="athletes[<?php echo e($athlete->athlete_id); ?>][e2_score]"
                                    class="form-control" required min="0" max="100" step="0.01">
                            </div>
                            <div class="form-group col-md-2">
                                <label>E3</label>
                                <input type="number" name="athletes[<?php echo e($athlete->athlete_id); ?>][e3_score]"
                                    class="form-control" required min="0" max="100" step="0.01">
                            </div>
                            
                            <div class="form-group col-md-2">
                                <label>CR</label>
                                <input type="number" name="athletes[<?php echo e($athlete->athlete_id); ?>][cr_score]"
                                    class="form-control" required min="0" max="100" step="0.01">
                            </div>
                            <div class="form-group col-md-2">
                                <label>ND</label>
                                <input type="number" name="athletes[<?php echo e($athlete->athlete_id); ?>][nd_score]"
                                    class="form-control" required min="0" max="100" step="0.01">
                            </div>
                            <div class="form-group col-md-2">
                                <label>D (click)</label>
                                <?php if($athlete->competition?->scoring_type == 'FIG'): ?>
                                    <input type="text" class="form-control d-score-input"
                                        name="athletes[<?php echo e($athlete->athlete_id); ?>][d_score]" required readonly
                                        placeholder="D" data-athlete="<?php echo e($athlete->athlete_id); ?>">
                                <?php else: ?>
                                    <input type="number" class="form-control"
                                        name="athletes[<?php echo e($athlete->athlete_id); ?>][d_score]" step="0.1"
                                        placeholder="Enter D Score" value="<?php echo e(old('d_score', $score->d_score ?? '')); ?>">
                                <?php endif; ?>

                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                <button class="btn btn-success">Submit Scores</button>
            </form>
        </div>
    </div>

    
    <div class="modal fade" id="dScoreModal" tabindex="-1" role="dialog" aria-labelledby="dScoreModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content border-0 shadow">
                <div class="modal-header bg-primary text-white">
                    <h5 class="modal-title">Calculate D Score (Difficulty)</h5>
                    <button type="button" class="close text-white" data-dismiss="modal"><span>&times;</span></button>
                </div>
                <div class="modal-body pb-1">
                    <div class="row">
                        <?php
                            $letters = [
                                'a' => 0.1,
                                'b' => 0.2,
                                'c' => 0.3,
                                'd' => 0.4,
                                'e' => 0.5,
                                'f' => 0.6,
                                'g' => 0.7,
                                'h' => 0.8,
                                'i' => 0.9,
                                'j' => 1.0,
                            ];
                        ?>
                        <?php $__currentLoopData = $letters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $letter => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="col-md-2 col-4 text-center mb-3">
                                <label class="text-uppercase font-weight-bold"><?php echo e($letter); ?>

                                    <br><small><?php echo e($value); ?></small></label>
                                <input type="number" class="form-control element-input" data-value="<?php echo e($value); ?>"
                                    data-letter="<?php echo e($letter); ?>" min="0" max="10" step="1"
                                    value="0">
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                    <div class="text-right mt-3">
                        <h5>Total D Score: <span id="calculatedDScore" class="text-success font-weight-bold">0.00</span>
                        </h5>
                    </div>
                </div>
                <div class="modal-footer bg-light">
                    <input type="hidden" id="targetDInput">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                    <button type="button" id="applyDScoreBtn" class="btn btn-success">Apply D Score</button>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    
    <script>
        let currentDInput = null;

        // Open modal on D input click
        $(document).on('click', '.d-score-input', function() {
            currentDInput = $(this);
            $('#targetDInput').val(currentDInput.attr('name'));
            $('#dScoreModal').modal('show');
            $('#calculatedDScore').text('0.00');
            $('.element-input').val(0);
        });

        // Live calculation of D score
        $(document).on('input', '.element-input', function() {
            let total = 0;
            $('.element-input').each(function() {
                let count = parseFloat($(this).val()) || 0;
                let value = parseFloat($(this).data('value'));
                total += count * value;
            });
            $('#calculatedDScore').text(total.toFixed(2));
        });

        // Apply calculated score
        $('#applyDScoreBtn').on('click', function() {
            let total = parseFloat($('#calculatedDScore').text());
            if (currentDInput) {
                currentDInput.val(total.toFixed(2));
            }
            $('#dScoreModal').modal('hide');
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('judge.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/judge/round/form.blade.php ENDPATH**/ ?>