<?php $__env->startSection('judge_content'); ?>
    <div class="container" style="min-height: 100vh; display: flex; align-items: center; justify-content: center;">
    <div class="w-100">
        <h3 class="text-center mb-3">Select a Competition</h3>

        <?php if($competitions->isEmpty()): ?>
            <p class="text-center">No competitions assigned to you.</p>
        <?php else: ?>
            <div class="row justify-content-center">
                <?php $__currentLoopData = $competitions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $competition): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-md-4 col-sm-6 mb-3">
                        <form action="<?php echo e(route('judge.setCompetition')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" name="competition_id" value="<?php echo e($competition->id); ?>">
                            <button type="submit" class="card text-left w-100 btn t p-3 text-start"
                                style="text-align: left;">
                                <h5 class="mb-1"><?php echo e($competition->name); ?></h5>
                                <p class="mb-0 text-muted">
                                    <?php echo e(\Carbon\Carbon::parse($competition->start_date)->format('Y-m-d')); ?>

                                    to
                                    <?php echo e(\Carbon\Carbon::parse($competition->end_date)->format('Y-m-d')); ?>

                                    <br>
                                    <strong>Location:</strong> <?php echo e($competition->location ?? 'N/A'); ?>

                                </p>
                            </button>
                        </form>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('judge.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/judge/competitions/index.blade.php ENDPATH**/ ?>