<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="ltr">
<!-- BEGIN: Head-->
<?php echo $__env->make('layouts.head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<!-- END: Head-->

<!-- BEGIN: Body-->

<body class="vertical-layout vertical-menu-modern 2-columns navbar-sticky footer-static" data-open="click"
    data-menu="vertical-menu-modern" data-col="2-columns">

    <!-- BEGIN: Top Navbar with Logout -->
    <nav class="navbar navbar-light bg-white border-bottom px-3">
        <div class="d-flex align-items-center w-100 justify-content-between">
            <!-- Left: User name button -->
            <a href="#" class="btn btn-sm btn-outline-info d-flex align-items-center px-3 rounded-pill">
                <i class="fa fa-user-circle me-2"></i>
                <span><?php echo e(Auth::user()->first_name); ?> <?php echo e(Auth::user()->last_name); ?></span>
            </a>

            <!-- Center: Competition name if exists -->
            <?php if(session('competition_name')): ?>
                <span class="fw-semibold text-primary">
                    🏆 <?php echo e(session('competition_name')); ?>

                </span>
            <?php endif; ?>

            <!-- Right: Logout button -->
            <a href="<?php echo e(route('logout')); ?>"
                onclick="event.preventDefault(); document.getElementById('logout-form').submit();"
                class="btn btn-sm btn-outline-danger">
                <i class="fa fa-sign-out-alt me-1"></i> Logout
            </a>

            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                <?php echo csrf_field(); ?>
            </form>
        </div>
    </nav>

    <!-- END: Top Navbar -->

    <!-- BEGIN: Content-->
    <div class="">
        <div class="content-overlay"></div>
        <?php echo $__env->yieldContent('judge_content'); ?>
    </div>
    <!-- END: Content-->

    <div class="sidenav-overlay"></div>
    <div class="drag-target"></div>

    <!-- BEGIN: Scripts-->
    <?php echo $__env->make('layouts.scripts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <!-- END: Scripts-->
</body>
<!-- END: Body-->

</html>
<?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/judge/master.blade.php ENDPATH**/ ?>