<?php $__env->startSection('css'); ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="card">
    <div class="card-header">
        <h4 class="card-title">Assign Athlete to Competition</h4>
    </div>

    <div class="card-body">
        <?php if($errors->any()): ?>
            <div class="alert alert-danger">
                <strong>Fix the following:</strong>
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?php echo e(route('competitionathlete.store')); ?>" method="POST">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-md-6 mb-2">
                    <label>Competition</label>
                    <select name="competition_id" class="form-control" required>
                        <option value="">Select Competition</option>
                        <?php $__currentLoopData = $competitions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $competition): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($competition->id); ?>"><?php echo e($competition->name); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-md-6 mb-2">
                    <label>Athlete</label>
                    <select name="athlete_id" class="form-control select2-athlete" required>
                        <option value="">Select Athlete</option>
                        
                    </select>
                </div>

                <div class="col-md-6 mb-2">
                    <label>Group</label>
                    <select name="group_id" class="form-control" required>
                        <option value="">Select Group</option>
                        
                    </select>
                </div>
            </div>

            <div class="mt-2">
                <button class="btn btn-primary">Assign</button>
                <a href="<?php echo e(route('competitionathlete.index')); ?>" class="btn btn-secondary">Cancel</a>
            </div>
        </form>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function () {
    const competitionSelect = document.querySelector('select[name="competition_id"]');
    const groupSelect = document.querySelector('select[name="group_id"]');
    const athleteSelect = document.querySelector('select[name="athlete_id"]');

    // Initialize empty select2 on page load
    $('.select2-athlete').select2({
        placeholder: 'Select Athlete',
        allowClear: true,
        width: '100%'
    });

    competitionSelect.addEventListener('change', function () {
        const competitionId = this.value;

        groupSelect.innerHTML = '<option value="">Select Group</option>';
        $(athleteSelect).html('<option value="">Select Athlete</option>').trigger('change');

        if (competitionId) {
            // Fetch groups
            fetch(`/get-competition-groups/${competitionId}`)
                .then(response => response.json())
                .then(groups => {
                    groups.forEach(group => {
                        const option = document.createElement('option');
                        option.value = group.id;
                        option.textContent = group.name;
                        groupSelect.appendChild(option);
                    });
                })
                .catch(error => console.error('Error fetching groups:', error));

            // Fetch athletes
            fetch(`/get-competition-athletes/${competitionId}`)
                .then(response => response.json())
                .then(athletes => {
                    // Clear & re-init athlete select
                    $(athleteSelect).empty().append('<option value="">Select Athlete</option>');
                    athletes.forEach(athlete => {
                        const option = new Option(`${athlete.first_name} ${athlete.last_name}`, athlete.id, false, false);
                        $(athleteSelect).append(option);
                    });
                    $(athleteSelect).val(null).trigger('change');
                    $(athleteSelect).select2({
                        placeholder: 'Search Athlete',
                        allowClear: true,
                        width: '100%'
                    });
                })
                .catch(error => console.error('Error fetching athletes:', error));
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/competition_athlete/create.blade.php ENDPATH**/ ?>