<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h4>Create Age Category</h4>
            <a href="<?php echo e(route('age_categories.index')); ?>" class="btn btn-secondary btn-sm">← Back to List</a>
        </div>
        <div class="card-body">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <strong>There were some problems with your input:</strong>
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('age_categories.store')); ?>">
                <?php echo csrf_field(); ?>

                <div class="form-group">
                    <label for="name">Category Name <span class="text-danger">*</span></label>
                    <input type="text" id="name" name="name" class="form-control"
                           value="<?php echo e(old('name')); ?>" required>
                </div>

                <div class="form-group">
                    <label for="min_age">Minimum Age</label>
                    <input type="date" id="min_age" name="min_age" class="form-control"
                           value="<?php echo e(old('min_age')); ?>">
                </div>

                <div class="form-group">
                    <label for="max_age">Maximum Age</label>
                    <input type="date" id="max_age" name="max_age" class="form-control"
                           value="<?php echo e(old('max_age')); ?>">
                </div>

                <button type="submit" class="btn btn-primary">Save Category</button>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/age_categories/create.blade.php ENDPATH**/ ?>