
<?php $__env->startSection('content'); ?>
    <div class="container py-4">
        <h3 class="mb-4">Certificates — <?php echo e($competition->title ?? 'Competition #' . $competition->id); ?></h3>


        <?php if(session('success')): ?>
            <div class="alert alert-success"><?php echo e(session('success')); ?></div>
        <?php endif; ?>


        <div class="card mb-4">
            <div class="card-header">Template</div>
            <div class="card-body">
                <form action="<?php echo e(route('certificates.template.store', $competition)); ?>" method="post"
                    enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label>Title</label>
                            <input type="text" name="title" class="form-control"
                                value="<?php echo e(old('title', optional($template)->title)); ?>" required>
                        </div>
                        <div class="form-group col-md-4">
                            <label>Background image (fixed size PNG/JPG)</label>
                            <input type="file" name="background" class="form-control-file">
                            <?php if($template && $template->background_path): ?>
                                <small class="text-muted d-block mt-2">Current:
                                    <code><?php echo e($template->background_path); ?></code></small>
                            <?php endif; ?>
                        </div>
                    </div>

<?php
  $cf = (array) data_get($template, 'custom_fields', []);
  $style = (array) data_get($template, 'style', []);
?>
                    <div class="form-row">
                        <div class="form-group col-md-4">
                            <label>Subtitle</label>
                           <input type="text" name="custom_fields[subtitle]" class="form-control"
       value="<?php echo e(old('custom_fields.subtitle', $cf['subtitle'] ?? '')); ?>">
                        </div>
                        <div class="form-group col-md-4">
                            <label>Footer note</label>
               <input type="text" name="custom_fields[footer]" class="form-control"
       value="<?php echo e(old('custom_fields.footer', $cf['footer'] ?? '')); ?>">
                        </div>
                    </div>


                    
                    <div class="form-row">
                        <div class="form-group col-md-3">
                            <label>Name font size (px)</label>
                 <input type="number" name="style[name_font]" class="form-control"
       value="<?php echo e(old('style.name_font', $style['name_font'] ?? 42)); ?>">

                        </div>
                        <div class="form-group col-md-3">
                            <label>Title font size (px)</label>
                           <input type="number" name="style[title_font]" class="form-control"
       value="<?php echo e(old('style.title_font', $style['title_font'] ?? 28)); ?>">
                        </div>
                        <div class="form-group col-md-3">
                            <label>Subtitle font size (px)</label>
                         <input type="number" name="style[subtitle_font]" class="form-control"
       value="<?php echo e(old('style.subtitle_font', $style['subtitle_font'] ?? 18)); ?>">
                        </div>
                    </div>


                    <button class="btn btn-primary">Save Template</button>
                    <a class="btn btn-outline-secondary" href="<?php echo e(route('certificates.preview', $competition)); ?>"
                        target="_blank">Preview</a>
                </form>
            </div>
        </div>


        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <span>Export</span>
                <form action="<?php echo e(route('certificates.exportAll', $competition)); ?>" method="post" class="form-inline">
                    <?php echo csrf_field(); ?>
                    <label class="mr-2">Batch size</label>
                    <input type="number" name="batch_size" class="form-control form-control-sm mr-2" value="40"
                        min="1" style="width: 90px;">
                    <button class="btn btn-success btn-sm">Export Whole Competition</button>
                </form>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('certificates.exportSelected', $competition)); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="table-responsive">
                        <table class="table table-striped table-sm">
                            <thead>
                                <tr>
                                    <th style="width:32px"><input type="checkbox" id="checkAll"></th>
                                    <th>Athlete</th>
                                    <th>Club</th>
                                    
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $athletes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $a): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><input type="checkbox" name="athlete_ids[]" value="<?php echo e($a->id); ?>"></td>
                                        <td><?php echo e($a->first_name); ?> <?php echo e($a->last_name); ?></td>
                                        <td><?php echo e(optional($a->club)->name); ?></td>
                                        
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                    <button class="btn btn-primary">Export Selected</button>
                </form>
            </div>
        </div>
    </div>


    <script>
        document.getElementById('checkAll').addEventListener('change', function() {
            document.querySelectorAll('input[name="athlete_ids[]"]').forEach(cb => cb.checked = this.checked);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/certificates/index.blade.php ENDPATH**/ ?>