<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('app-assets/vendors/css/vendors.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/dataTables.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/responsive.bootstrap4.min.css')); ?>">
    <link rel="stylesheet" type="text/css"
        href="<?php echo e(asset('app-assets/vendors/css/tables/datatable/buttons.bootstrap4.min.css')); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <section id="club-datatable">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h4 class="card-title mb-0">Clubs</h4>
                        <a href="<?php echo e(route('clubs.create')); ?>" class="btn btn-primary">
                            <i class="bx bx-plus"></i> Add Club
                        </a>
                    </div>
                    <div class="card-body card-dashboard">
                        <div class="table-responsive">
                       <table class="table zero-configuration">
    <thead>
        <tr>
            <th>*</th>
            <th>ID</th>
            <th>Name</th>
            <th>Owner</th>
            <th>Country</th>
            <th>Dates</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </thead>

    <tbody>
        <?php $__currentLoopData = $clubs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $club): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
    $today = \Carbon\Carbon::today();
    $start = $club->start_date ? \Carbon\Carbon::parse($club->start_date) : null;
    $end   = $club->end_date ? \Carbon\Carbon::parse($club->end_date) : null;

    if (is_null($start) && is_null($end)) {
        // both missing → expired
        $status = 'Expired';
        $badge = 'danger';
    } elseif ($end && $end->lt($today)) {
        // end date passed
        $status = 'Expired';
        $badge = 'danger';
    } elseif ($start && $start->gt($today)) {
        // starts in future
        $status = 'Upcoming';
        $badge = 'info';
    } else {
        // valid and ongoing
        $status = 'Active';
        $badge = 'success';
    }
?>

            <tr>
                <td><?php echo e($loop->iteration); ?></td>
                <td><?php echo e($club->id); ?></td>
                <td><?php echo e($club->name); ?></td>
                <td><?php echo e($club->user?->email); ?></td>
                <td><?php echo e($club->country?->name ?? '-'); ?></td>

                
                <td>
                    <small>
                        <?php echo e($club->start_date ?? '—'); ?>

                        —
                        <?php echo e($club->end_date ?? 'Open'); ?>

                    </small>
                </td>

                
                <td>
                    <span class="badge badge-<?php echo e($badge); ?>"><?php echo e($status); ?></span>
                </td>

                <td>
                    <a href="<?php echo e(route('clubs.edit', $club->id)); ?>" class="btn btn-sm btn-warning">Edit</a>
                    <button type="button" class="btn btn-sm btn-danger btn-delete"
                            data-url="<?php echo e(route('clubs.destroy', $club->id)); ?>">
                        Delete
                    </button>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>

    <tfoot>
        <tr>
            <th>*</th>
            <th>ID</th>
            <th>Name</th>
            <th>Owner</th>
            <th>Country</th>
            <th>Dates</th>
            <th>Status</th>
            <th>Actions</th>
        </tr>
    </tfoot>
</table>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
    <!-- BEGIN: Page Vendor JS-->
    <script src="<?php echo e(asset('app-assets/vendors/js/ui/jquery.sticky.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/buttons.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('app-assets/vendors/js/tables/datatable/vfs_fonts.js')); ?>"></script>
    <!-- END: Page Vendor JS-->



    <!-- BEGIN: Page JS-->
    <script src="<?php echo e(asset('app-assets/js/scripts/datatables/datatable.js')); ?>"></script>
    <!-- END: Page JS-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/clubs/index.blade.php ENDPATH**/ ?>