<?php $__env->startSection('auth-content'); ?>
    <style>
        .highlight-row td {
            background-color: #f8f9fa !important;
            font-weight: bold;
        }

        .fade-section {
            opacity: 0;
            transition: opacity 0.4s ease-in-out;
        }

        .fade-section.showing {
            opacity: 1;
        }

        .nav-pills .nav-link.active {
            background-color: #ffc107;
            color: #212529;
        }

        .page-indicator {
            font-size: 0.9em;
            color: #6c757d;
        }
    </style>

    <div class="container-fluid py-3">
        <div class="d-flex justify-content-between align-items-center mb-3">
            <h2 id="competitionName" class="mb-0" style="font-weight:bold;font-size:2.5em;">
                <i class="bx bx-trophy"></i> <?php echo e($activeCompetitions->first()->name ?? 'Competition'); ?>

            </h2>
        </div>

        
        <ul class="nav nav-pills justify-content-center mb-4 flex-wrap" id="ageGroupTabs">
            <?php $__currentLoopData = $ageCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $age): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="nav-item m-1">
                    <span class="nav-link" data-age="<?php echo e($age->name); ?>" style="font-size:1.2em; cursor:pointer;">
                        <?php echo e($age->name); ?>

                    </span>
                </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>

        
        <div class="leaderboard-sections">
            <?php $__currentLoopData = $activeCompetitions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $competition): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $apparatuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $apparatus): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php $__currentLoopData = $ageCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $age): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php if($competition->scoring_type === 'FIG'): ?>
                            <?php
                                $athletes =
                                    $athleteRankings[$competition->name][$apparatus->name][$age->name] ?? collect();
                                $isEmpty = $athletes->isEmpty();
                                $sorted = $athletes
                                    ->sortByDesc(fn($a) => optional($a->scores->first())->final_score)
                                    ->values();
                                $chunks = $sorted->chunk(10);
                            ?>

                            <div class="leaderboard-section <?php echo e($isEmpty ? 'skip-section' : ''); ?> fade-section"
                                data-competition="<?php echo e($competition->name); ?>" data-apparatus="<?php echo e($apparatus->name); ?>"
                                data-age="<?php echo e($age->name); ?>" data-level="none" style="display:none;">

                                <div class="text-center bg-success text-white py-2 mb-2"
                                    style="font-size:1.8em;font-weight:bold;">
                                    <?php echo e($apparatus->name); ?> — <?php echo e($age->name); ?>

                                </div>

                                <div class="table-responsive">
                                    <div class="text-right mb-1">
                                        <small class="page-indicator"></small>
                                    </div>

                                    <table class="table table-bordered table-hover text-center mb-0"
                                        style="font-size:1.3em;">
                                        <thead class="table-light">
                                            <tr>
                                                <th>#</th>
                                                <th>NF</th>
                                                <th>Athlete</th>
                                                <th>DScore</th>
                                                <th>Bonus</th>
                                                <th>CR Score</th>
                                                <th>ND Score</th>
                                                <th>Final</th>
                                            </tr>
                                        </thead>

                                        <?php $__currentLoopData = $chunks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pageIndex => $chunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tbody class="page-group" data-page="<?php echo e($pageIndex); ?>"
                                                style="<?php echo e($pageIndex === 0 ? '' : 'display:none;'); ?>">
                                                <?php $__currentLoopData = $chunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $athlete): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php $score=$athlete->scores->first(); ?>
                                                    <tr
                                                        class="highlight-row <?php echo e($i === 0 ? 'table-success' : ($i === 1 ? 'table-warning' : ($i === 2 ? 'table-info' : ''))); ?>">
                                                        <td><?php echo e($pageIndex * 10 + $i + 1); ?></td>
                                                        <td><?php echo e($athlete->country?->name ?? '—'); ?></td>
                                                        <td><?php echo e($athlete->first_name); ?> <?php echo e($athlete->last_name); ?></td>
                                                        <td><?php echo e($score ? number_format($score->d_score, 2) : '-'); ?></td>
                                                        <td><?php echo e($score ? number_format($score->bonus, 2) : '-'); ?></td>
                                                        <td><?php echo e($score ? number_format($score->cr_score, 2) : '-'); ?></td>
                                                        <td><?php echo e($score ? number_format($score->nd_score, 2) : '-'); ?></td>
                                                        <td>
                                                            <?php if($score): ?>
                                                                <?php echo e(number_format($score->final_score, 2)); ?>

                                                                <?php if($i === 0): ?>
                                                                    🥇
                                                                <?php elseif($i === 1): ?>
                                                                    🥈
                                                                <?php elseif($i === 2): ?>
                                                                    🥉
                                                                <?php endif; ?>
                                                            <?php else: ?>
                                                                No score
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </table>
                                </div>
                            </div>
                        <?php else: ?>
                            <?php $__currentLoopData = $levels; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $level): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $athletes =
                                        $athleteRankings[$competition->name][$apparatus->name][$age->name][
                                            $level->name
                                        ] ?? collect();
                                    $isEmpty = $athletes->isEmpty();
                                    $sorted = $athletes
                                        ->sortByDesc(fn($a) => optional($a->scores->first())->final_score)
                                        ->values();
                                    $chunks = $sorted->chunk(10);
                                ?>

                                <div class="leaderboard-section <?php echo e($isEmpty ? 'skip-section' : ''); ?> fade-section"
                                    data-competition="<?php echo e($competition->name); ?>" data-apparatus="<?php echo e($apparatus->name); ?>"
                                    data-age="<?php echo e($age->name); ?>" data-level="<?php echo e($level->name); ?>" style="display:none;">

                                    <div class="text-center bg-success text-white py-2 mb-2"
                                        style="font-size:1.8em;font-weight:bold;">
                                        Level <?php echo e($level->name); ?> — <?php echo e($apparatus->name); ?>

                                    </div>

                                    <div class="table-responsive">
                                        <div class="text-right mb-1">
                                            <h3 class="page-indicator"></h3>
                                        </div>
                                        <table class="table table-bordered table-hover text-center mb-0"
                                            style="font-size:1.3em;">
                                            <thead class="table-light">
                                                <tr>
                                                    <th>#</th>
                                                    <th>NF</th>
                                                    <th>Athlete</th>
                                                    <th>DScore</th>
                                                    <th>Bonus</th>
                                                    <th>CR Score</th>
                                                    <th>ND Score</th>
                                                    <th>Final</th>
                                                </tr>
                                            </thead>

                                            <?php $__currentLoopData = $chunks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pageIndex => $chunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tbody class="page-group" data-page="<?php echo e($pageIndex); ?>"
                                                    style="<?php echo e($pageIndex === 0 ? '' : 'display:none;'); ?>">
                                                    <?php $__currentLoopData = $chunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $athlete): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php $score=$athlete->scores->first(); ?>
                                                        <tr
                                                            class="highlight-row <?php echo e($i === 0 ? 'table-success' : ($i === 1 ? 'table-warning' : ($i === 2 ? 'table-info' : ''))); ?>">
                                                            <td><?php echo e($pageIndex * 10 + $i + 1); ?></td>
                                                            <td><?php echo e($athlete->country?->name ?? '—'); ?></td>
                                                            <td><?php echo e($athlete->first_name); ?> <?php echo e($athlete->last_name); ?></td>
                                                            <td><?php echo e($score ? number_format($score->d_score, 2) : '-'); ?></td>
                                                            <td><?php echo e($score ? number_format($score->bonus, 2) : '-'); ?></td>
                                                            <td><?php echo e($score ? number_format($score->cr_score, 2) : '-'); ?></td>
                                                            <td><?php echo e($score ? number_format($score->nd_score, 2) : '-'); ?></td>
                                                            <td>
                                                                <?php if($score): ?>
                                                                    <?php echo e(number_format($score->final_score, 2)); ?>

                                                                    <?php if($i === 0): ?>
                                                                        🥇
                                                                    <?php elseif($i === 1): ?>
                                                                        🥈
                                                                    <?php elseif($i === 2): ?>
                                                                        🥉
                                                                    <?php endif; ?>
                                                                <?php else: ?>
                                                                    No score
                                                                <?php endif; ?>
                                                            </td>
                                                        </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </tbody>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </table>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>

    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let competitions = <?php echo json_encode($activeCompetitions->pluck('name'), 15, 512) ?>;
            let apparatuses = <?php echo json_encode($apparatuses->pluck('name'), 15, 512) ?>;
            let ages = <?php echo json_encode($ageCategories->pluck('name'), 15, 512) ?>;
            let levels = <?php echo json_encode($levels->pluck('name'), 15, 512) ?>;
            let scoringTypes = <?php echo json_encode($activeCompetitions->pluck('scoring_type', 'name'), 512) ?>;

            let compIndex = 0,
                appIndex = 0,
                ageIndex = 0,
                levelIndex = 0,
                paused = false;

            function highlightAge(age) {
                document.querySelectorAll('#ageGroupTabs .nav-link').forEach(el => {
                    el.classList.toggle('active', el.dataset.age === age);
                });
            }

          function nextSection() {
  if (paused) return;
  let attempts = 0;
  const max = competitions.length * apparatuses.length * ages.length * levels.length;

  while (attempts < max) {
    let comp = competitions[compIndex],
        app = apparatuses[appIndex],
        age = ages[ageIndex],
        type = scoringTypes[comp],
        level = (type === 'FIG') ? 'none' : levels[levelIndex];

    let sel = `.leaderboard-section[data-competition="${comp}"][data-apparatus="${app}"][data-age="${age}"][data-level="${level}"]`;
    let sec = document.querySelector(sel);

    if (sec && !sec.classList.contains('skip-section')) {
      // Hide others and show this one
      document.querySelectorAll('.leaderboard-section').forEach(s => { 
        s.style.display = 'none'; 
        s.classList.remove('showing'); 
      });

      sec.style.display = 'block';
      sec.classList.add('showing');
      document.getElementById('competitionName').textContent = comp;
      highlightAge(age);
      rotatePages(sec);

      // ✅ Advance indexes for the NEXT call
      if (type === 'FIG') {
        ageIndex++;
        if (ageIndex >= ages.length) {
          ageIndex = 0;
          appIndex++;
          if (appIndex >= apparatuses.length) {
            appIndex = 0;
            compIndex++;
            if (compIndex >= competitions.length) compIndex = 0;
          }
        }
      } else {
        levelIndex++;
        if (levelIndex >= levels.length) {
          levelIndex = 0;
          ageIndex++;
          if (ageIndex >= ages.length) {
            ageIndex = 0;
            appIndex++;
            if (appIndex >= apparatuses.length) {
              appIndex = 0;
              compIndex++;
              if (compIndex >= competitions.length) compIndex = 0;
            }
          }
        }
      }
      break; // exit while after showing and advancing
    }

    // If not valid → skip ahead
    if (type === 'FIG') {
      ageIndex++;
      if (ageIndex >= ages.length) {
        ageIndex = 0; appIndex++;
        if (appIndex >= apparatuses.length) {
          appIndex = 0; compIndex++;
          if (compIndex >= competitions.length) compIndex = 0;
        }
      }
    } else {
      levelIndex++;
      if (levelIndex >= levels.length) {
        levelIndex = 0; ageIndex++;
        if (ageIndex >= ages.length) {
          ageIndex = 0; appIndex++;
          if (appIndex >= apparatuses.length) {
            appIndex = 0; compIndex++;
            if (compIndex >= competitions.length) compIndex = 0;
          }
        }
      }
    }
    attempts++;
  }
}

            function rotatePages(section) {
                let pages = section.querySelectorAll('.page-group');
                if (pages.length <= 1) return;
                let current = 0;
                const indicator = section.querySelector('.page-indicator');
                indicator.textContent = `Page 1 / ${pages.length}`;
                clearInterval(section.pageTimer);
                section.pageTimer = setInterval(() => {
                    if (!section.classList.contains('showing')) return;
                    pages[current].style.display = 'none';
                    current = (current + 1) % pages.length;
                    pages[current].style.display = '';
                    indicator.textContent = `Page ${current+1} / ${pages.length}`;
                }, 10000);
            }

            function startLoop() {
                setInterval(nextSection, <?php echo e($cycleDuration * 1000); ?>);
            }

            window.addEventListener('keydown', e => {
                if (['INPUT', 'TEXTAREA'].includes(e.target.tagName)) return;
                const k = e.key.toLowerCase();
                if (k === 'p') paused = true;
                if (k === 'r') paused = false;
                if (k === 's') {
                    compIndex = appIndex = ageIndex = levelIndex = 0;
                    paused = false;
                    nextSection();
                }
            });

            nextSection();
            startLoop();
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('auth.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/leaderboard/show.blade.php ENDPATH**/ ?>