<?php $__env->startSection('content'); ?>
<div class="container">
    <div class="card">
        <div class="card-header"><h4>Edit Profile</h4></div>
        <div class="card-body">
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <strong>There were some problems with your input:</strong>
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
            <form method="POST" action="<?php echo e(route('profile.update')); ?>" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>

                <div class="form-group">
                    <label for="name">Name</label>
                    <input type="text" name="first_name" value="<?php echo e(old('first_name', auth()->user()->first_name)); ?>" class="form-control" required>
                </div>
                <div class="form-group">
                    <label for="name">Name</label>
                    <input type="text" name="last_name" value="<?php echo e(old('last_name', auth()->user()->last_name)); ?>" class="form-control" required>
                </div>

                <div class="form-group">
                    <label for="email">Email</label>
                    <input type="email" name="email" value="<?php echo e(old('email', auth()->user()->email)); ?>" class="form-control" required>
                </div>

                <div class="form-group">
                    <label for="profile">Profile Photo</label>
                    <?php if(auth()->user()->profile): ?>
                        <div class="mb-2">
                            <img src="<?php echo e(asset(auth()->user()->profile)); ?>" alt="Current Profile" height="80">
                        </div>
                    <?php endif; ?>
                    <input type="file" name="profile" class="form-control-file">
                </div>

                <button type="submit" class="btn btn-primary">Update Profile</button>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\artistic_gymnastics\resources\views/profile/edit.blade.php ENDPATH**/ ?>